/*
 * structures
 */

struct xdpy {

  Display *dpy;
  int screen;
  Window rootwin;

  int depth;
  int width, height;
  int black, white;
};

/*
 * graph
 */

struct graph {
  int nlines;
  char *title;
  char **names;
  int **before, **after;
  u_long *colors; 
  u_long backcolor;
  int nslot, ptr;
  int **lindat;
  int leglines;
  int maxval;
};

/*
 * prototypes
 */

u_long create_color __P((struct xdpy *, Colormap, char *, u_long));
XFontStruct *create_font __P((struct xdpy *, char *, char *));
struct graph *create_graph __P((int, char *, char **, int **, int **, u_long *, 
				u_long));
int draw_barbox __P((struct xdpy *, Window, GC, XFontStruct *, 
		     int, int, int, int, int, char **, u_long *, u_long *,
		     u_long));
int draw_barlvl __P((struct xdpy *, Window, GC, XFontStruct *, 
		     int, int, int, int, int, char **, u_long *, u_long *,
		     u_long));
void draw_graph __P((struct xdpy *, Window, GC, XFontStruct *, int, int, int,
		     int, struct graph *, int));
GC create_gc __P((struct xdpy *, Drawable, u_long, u_long));
Display *open_display __P((char *, struct xdpy *));
Window open_window __P((struct xdpy *, Window,  int, int, int, int, 
			u_long, u_long, u_long, Visual *, int));
void set_classhints __P((struct xdpy *, Window, char *, char *));
void set_sizehints __P((struct xdpy *, Window, int, int, int, int));
void set_stdhints __P((struct xdpy *, Window, char *, char *, 
		       int, int, int, int));
void set_windowname __P((struct xdpy *, Window, char *));
void set_wmhints __P((struct xdpy *, Window, int));
int setup_colormap __P((struct xdpy *, int, Window, Visual *, Colormap *));
int setup_visual __P((struct xdpy *, int, Visual **, int *));

/*
 * macros
 */

#define get_fontheight(F) ((F)->ascent + (F)->descent)
