#include <stdio.h>
#include <string.h>

#include "xtux.h"
#include "server.h"
#include "entity.h"
#include "clients.h"
#include "sv_net.h"
#include "sv_netmsg_send.h"
#include "game.h"

extern server_t server;
extern game_t game;

/* Send message MESSAGE_TYPE to client */
void sv_netmsg_send_message(client_t *cl, byte message_type)
{
    netmsg msg;

    msg.type = message_type;
    net_send_message(cl->fd, msg);

}


void sv_netmsg_send_version(client_t *cl)
{
    netmsg msg;

    msg.type = NETMSG_VERSION;
    msg.version.ver[0] = VER0;
    msg.version.ver[1] = VER1;
    msg.version.ver[2] = VER2;
    net_send_message(cl->fd, msg);

}


void sv_netmsg_send_textmessage(client_t *cl, char *sender, char *string)
{
    netmsg msg;

    msg.type = NETMSG_TEXTMESSAGE;
    snprintf(msg.textmessage.sender, 32, sender);
    snprintf(msg.textmessage.string, 32, string);
    net_send_message(cl->fd, msg);

}


void sv_netmsg_send_sv_info(client_t *cl)
{
    netmsg msg;
    
    msg.type = NETMSG_SV_INFO;
    strncpy(msg.sv_info.map_name, game.map_name, 32);
    strncpy(msg.sv_info.sv_name, server.name, 32 );
    msg.sv_info.players = server.clients;
    net_send_message(cl->fd, msg);

}


void sv_netmsg_send_changelevel(client_t *cl)
{
    netmsg msg;
    
    msg.type = NETMSG_CHANGELEVEL;
    strncpy(msg.changelevel.map_name, game.map_name, 32);
    printf("Sending changelevel message with value \"%s\"\n",game.map_name); 
    net_send_message(cl->fd, msg);

}


void sv_netmsg_send_update_statusbar(client_t *cl)
{
    netmsg msg;

    msg.type = NETMSG_UPDATE_STATUSBAR;
    msg.update_statusbar.health = cl->health;
    msg.update_statusbar.ammo = cl->ammo;
    msg.update_statusbar.weapon = cl->weapon;
    msg.update_statusbar.frags = cl->frags;
    net_send_message(cl->fd, msg);

}


void sv_netmsg_send_rejection(int fd, char *reason)
{
    netmsg msg;
  
    msg.type = NETMSG_REJECTION;
    strncpy( msg.rejection.reason, reason, 32 );
    net_send_message(fd, msg);
    printf("rejected login from \"%s\", %s\n", net_get_address(fd), reason);

}


void sv_netmsg_send_gamemessage(int fd, char *str, int everyone)
{
    netmsg msg;

    msg.type = NETMSG_GAMEMESSAGE;
    strncpy(msg.gamemessage.string, str, TEXTMESSAGE_STRLEN);
    if( everyone )
	sv_net_send_to_all(msg);
    else
	net_send_message(fd, msg);

}
