#include <stdlib.h>
#include <stdio.h>

#include "xtux.h"
#include "server.h"
#include "entity.h"
#include "clients.h"
#include "misc.h"

extern map_t *map;

/* Give co-ordinates of top left hand corner of view window centering around
   the clients entity */
shortpoint_t calculate_screenpos(client_t *cl)
{
    shortpoint_t p;
    animation_t *ani;
    ent_type_t *et;
    netshort x, y;

    if( (et = entity_type(cl->ent->type)) == NULL )
	ERR_QUIT("Invalid entity type for focus", -1);

    ani = et->animation[ cl->ent->mode ];
    if( ani == NULL ) {
	if( (ani = et->animation[ ALIVE ]) == NULL ) {
	    printf("ERROR: Animation type for ent %s, mode %d undefined\n",
		   et->name, cl->ent->mode);
	    ERR_QUIT("Damnit, fix your \"entity\" file!", -1);
	}
    }

    /* x,y = middle of focus entity */
    x = cl->ent->x + ani->img_w/2;
    y = cl->ent->y + ani->img_h/2;

    /* Center on focus */
    x -= cl->view_w / 2;
    y -= cl->view_h / 2;

    /* Check view area is inside map boundaries. */
    if( x >= map->width * TILE_W - cl->view_w )
        x = map->width * TILE_W - cl->view_w;
    else if( x < 0 )
        x = 0;

    if( y >= map->height * TILE_H - cl->view_h)
        y = map->height * TILE_H - cl->view_h;
    else if( y < 0 )
        y = 0;

    p.x = x;
    p.y = y;
    return p;

}
