#include <stdio.h>

#include "xtux.h"
#include "server.h"
#include "entity.h"
#include "sv_map.h"
#include "game.h"

extern int class_population[NUM_ENT_CLASSES];

game_t game;
int told;

void game_start(void)
{

    told = 0;
    printf("GAME START\n");

}



void game_update(void)
{

    if( game.changelevel ) {
	sv_map_changelevel(game.next_map_name, game.mode);
	game.changelevel = 0;
    }

    if( game.mode == BUNNYBASH ) {
	if( class_population[ NEUTRAL ] == 0 && told == 0 ) {
	    printf("All the neutrals are dead!\n");
	    told = 1; /* Only tell us once */
	}
    } else if( game.mode == SAVETHEWORLD ) {
	if( class_population[ BADDIE ] == 0 && told == 0 ) {
	    printf("All baddies are dead, we should do something...\n");
	    told = 1;
	}
    }

}


void game_end(void)
{

    printf("GAME END\n");

}
