#define NETMSG_STRLEN 32
#define TEXTMESSAGE_STRLEN 128

enum {
    NETMSG_NONE,              /* SERVER  <---> CLIENT */
    NETMSG_NOOP,              /* SERVER  <---> CLIENT */
    NETMSG_QUERY_VERSION,     /* SERVER  <---> CLIENT */
    NETMSG_VERSION,           /* SERVER  <---> CLIENT */
    NETMSG_TEXTMESSAGE,       /* SERVER  <---> CLIENT */
    NETMSG_QUIT,              /* SERVER  <---> CLIENT */
    NETMSG_REJECTION,         /* SERVER   ---> CLIENT */
    NETMSG_SV_INFO,           /* SERVER   ---> CLIENT */
    NETMSG_CHANGELEVEL,       /* SERVER   ---> CLIENT */
    NETMSG_START_FRAME,       /* SERVER   ---> CLIENT */
    NETMSG_END_FRAME,         /* SERVER   ---> CLIENT */
    NETMSG_ENTITY,            /* SERVER   ---> CLIENT */
    NETMSG_MYENTITY,          /* SERVER   ---> CLIENT */
    NETMSG_PARTICLES,         /* SERVER   ---> CLIENT */
    NETMSG_UPDATE_STATUSBAR,  /* SERVER   ---> CLIENT */
    NETMSG_JOIN,              /* CLIENT   ---> SERVER */
    NETMSG_READY,             /* CLIENT   ---> SERVER */
    NETMSG_QUERY_SV_INFO,     /* CLIENT   ---> SERVER */
    NETMSG_CL_UPDATE,         /* CLIENT   ---> SERVER */
    NETMSG_GAMEMESSAGE,       /* SERVER   ---> CLIENT */

    /* Keep this last */
    NUM_NETMESSAGES
};

/******** Message Structures ********/
typedef struct {
    byte type;
} netmsg_none;

typedef struct {
    byte type;
} netmsg_noop;

typedef struct {
    byte type;
} netmsg_query_version;

typedef struct {
    byte type;
    byte ver[3]; /* ie '1'.'0'.'0'*/
} netmsg_version;

typedef struct {
    byte type;
    char sender[NETMSG_STRLEN];
    char string[TEXTMESSAGE_STRLEN];
} netmsg_textmessage;

typedef struct {
    byte type;
} netmsg_quit;

/* SERVER --> CLIENT */
typedef struct {
    byte type;
    char reason[NETMSG_STRLEN];
} netmsg_rejection;

typedef struct {
    byte type;
    byte players;
    byte game_type;
    byte fps;
    char sv_name[NETMSG_STRLEN];
    char map_name[NETMSG_STRLEN];
} netmsg_sv_info;

typedef struct {
    byte type;
    char map_name[NETMSG_STRLEN];
} netmsg_changelevel;

typedef struct {
    byte type;
    shortpoint_t screenpos;
} netmsg_start_frame;

typedef struct {
    byte type;
} netmsg_end_frame;

typedef struct {
    byte type;
    byte entity_type;
    byte dir;
    byte mode;
    netshort x;
    netshort y;
    byte img;
    byte weapon;
} netmsg_entity;

/* myentity is the same as entity, but with a different type */

typedef struct {
    byte type;
    byte effect;
    byte dir;
    byte color1;
    byte color2;
    netshort x;
    netshort y;
    netshort length;
} netmsg_particles;

typedef struct {
    byte type;
    byte health;
    byte weapon;
    netshort frags;
    netshort ammo;
} netmsg_update_statusbar;


/* CLIENT -> SERVER */
typedef struct {
    byte type;
    byte gamemode;
    char name[NETMSG_STRLEN];
    char map_name[NETMSG_STRLEN];
} netmsg_join;

typedef struct {
    byte type;
    byte entity_type;
    byte color1;
    byte color2;
    netshort view_w;
    netshort view_h;
} netmsg_ready;

typedef struct {
    byte type;
} netmsg_query_sv_info;

typedef struct {
    byte type;
    byte dir;
    byte keypress;  /* Bit array of key presses */
} netmsg_cl_update;


typedef struct {
    byte type;
    char string[TEXTMESSAGE_STRLEN];
} netmsg_gamemessage;


typedef union {
    /****************** KEEP THIS FIRST ****************/
    byte type; /* Lined up with the msg type's in the various struct's */
    /******************  DON'T TOUCH!!! ****************/
    /* SV <--> CL */
    netmsg_noop              noop;
    netmsg_query_version     query_version;
    netmsg_version           version;
    netmsg_textmessage       textmessage;
    netmsg_quit              quit;
    /* SV  --> CL */
    netmsg_rejection         rejection;
    netmsg_sv_info           sv_info;
    netmsg_changelevel       changelevel;
    netmsg_start_frame       start_frame;
    netmsg_end_frame         end_frame;
    netmsg_entity            entity;
    netmsg_particles         particles;
    netmsg_update_statusbar  update_statusbar;
    netmsg_gamemessage       gamemessage;
    /* SV <--  CL */
    netmsg_join              join;
    netmsg_ready             ready;
    netmsg_query_sv_info     query_sv_info;
    netmsg_cl_update         cl_update;
} netmsg;
