#include "net_msg.h"

#define NETBUFSIZ 4096

/* Netstat types */
typedef enum {
    NS_NONE,
    NS_TOTAL,
    NS_RECENT,
    NUM_NETSTATS
} netstats_t;

int net_init(void);
vector_t net_stats(netstats_t type);
int net_buffered_read(int fd);
netmsg net_get_message(void);
int net_read_frame(int fd);
int net_send_message(int fd, netmsg msg);
int net_message_size(byte msg_type);
char *net_message_name(byte msg_type);
char *net_get_address(int fd);
