#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "xtux.h"
#include "client.h"
#include "draw.h"
#include "entity.h"
#include "cl_net.h"
#include "cl_netmsg_recv.h"
#include "cl_netmsg_send.h"
#include "particle.h"

extern client_t client;
extern map_t *map;
extern netmsg my_entity;

void cl_netmsg_recv_query_version(netmsg msg)
{
    cl_netmsg_send_version();
}


void cl_netmsg_recv_version(netmsg msg)
{
    printf("Remote version = %c.%c.%c\n",
	   msg.version.ver[0], msg.version.ver[1], msg.version.ver[2]);
}


void cl_netmsg_recv_textmessage(netmsg msg)
{

    if( !strcmp(msg.textmessage.sender, "SERVER") )
	printf("%s\n", msg.textmessage.string);
    else
	printf("%s: %s\n", msg.textmessage.sender, msg.textmessage.string);
}


void cl_netmsg_recv_quit(netmsg msg)
{
    cl_net_connection_lost(NULL);
}


/* We should only get this at login (where it's handled). So if we
   recieve it, something must definately be wrong! */
void cl_netmsg_recv_rejection(netmsg msg)
{
    char buf[64];

    snprintf(buf, 64, "Login refused: %s\n", msg.rejection.reason);
    cl_net_connection_lost(buf);

}


void cl_netmsg_recv_sv_info(netmsg msg)
{
    
    printf("Server name = %s. Map = %s, Players = %d\n",
	   msg.sv_info.sv_name, msg.sv_info.map_name,
	   msg.sv_info.players);
    strcpy(client.map, msg.sv_info.map_name);

}



/* If we recieve this, we have status of JOINING on the server till we are
   done changing level, where we send the ready message to rejoin the game */
void cl_netmsg_recv_changelevel(netmsg msg)
{

    printf("CHANGING LEVEL to \"%s\"\n", msg.changelevel.map_name);
    fflush(NULL);

    particle_clear();
    strcpy(client.map, msg.changelevel.map_name);
    map_close(&map);

    cl_change_map(client.map);

}

 /* msecs since last update, used for animation purposes. */
static msec_t last_update;

void cl_netmsg_recv_start_frame(netmsg msg)
{
    if( client.state == GAME_JOIN ) {
	last_update = gettime();
	client.state = GAME_PLAY; /* Got first start frame, we're playing */
    }

    client.screenpos = msg.start_frame.screenpos;

    if( client.state == GAME_PLAY ) {
	/* Draw layers of game world which are below the entities */
	draw_map( client.screenpos );
	particles_draw( PTL_BOTTOM ); /* Bottom layer of particles */
    }

}


void cl_netmsg_recv_end_frame(netmsg msg)
{
    msec_t now;
    float secs;

    if( client.state == GAME_PLAY ) {
	particles_draw( PTL_TOP ); /* Top layer of particles */
	if( map->toplevel )
	    draw_map_toplevel( client.screenpos );

	now = gettime();
	secs = now - last_update;
	secs /= (float)M_SEC; /* Convert to seconds */
	particle_update( secs );
	last_update = now;
    }

}


void cl_netmsg_recv_entity(netmsg msg)
{
    if( client.state == GAME_PLAY )
	entity_draw(msg.entity);
}


void cl_netmsg_recv_myentity(netmsg msg)
{
    my_entity = msg;
    if( client.state == GAME_PLAY )
	entity_draw(msg.entity);
}


void cl_netmsg_recv_particles(netmsg msg)
{
    create_particles(msg.particles);
}


void cl_netmsg_recv_update_statusbar(netmsg msg)
{

    if( client.ammo != msg.update_statusbar.ammo
	|| client.weapon != msg.update_statusbar.weapon
	|| client.frags != msg.update_statusbar.frags
	|| client.health != msg.update_statusbar.health ) {
	/* Update local copies */
	client.ammo = msg.update_statusbar.ammo;
	client.weapon = msg.update_statusbar.weapon;
	client.frags = msg.update_statusbar.frags;
	client.health = msg.update_statusbar.health;
	if( client.textentry == 0 )
	    draw_status_bar();
    }

}


extern int draw_message;
extern char center_message[TEXTMESSAGE_STRLEN];
extern msec_t message_start;

void cl_netmsg_recv_gamemessage(netmsg msg)
{

    draw_message = 1;
    message_start = gettime();
    strncpy(center_message, msg.gamemessage.string, TEXTMESSAGE_STRLEN);

}
