/*  Xsqlmenu
 *  Copyright (C) 1996-2000 Kees Lemmens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include "Xsqldefs.h"
#include "Recorddefs.h"

/* These are the routines that setup a search form and maintain it. Search
 * items should be entered using '%' or '_' wildcards if they do not match
 * exactly. See SQL specifications for details about wildcards.
 */

void RecordPrevious(FL_OBJECT *ob, long parent)
{
   FD_Record *fd_Rec = (FD_Record *)parent;
   Info_t *I = (Info_t *)fd_Rec->vdata;
   SQL_ROW row;
   int y;
   
   sql_data_seek(I->Res,--fd_Rec->ldata);
   if((row = sql_fetch_row(I->Res)) == NULL)
   {
      fl_set_object_lcol(fd_Rec->Previous,FL_INACTIVE_COL);
      fd_Rec->ldata++;
      return;
   };
   
   for(y=0;y<I->Numflds;y++)
   {  /* fix v1.03 : avoid zero pointers being referenced */
      if(row[y] != NULL) 
	fl_set_input(fd_Rec->Inputs[y],row[y]);
   }
   fl_set_object_lcol(fd_Rec->Next,FL_BLACK);
}

void RecordNext(FL_OBJECT *ob, long parent)
{
   FD_Record *fd_Rec = (FD_Record *)parent;
   Info_t *I = (Info_t *)fd_Rec->vdata;
   SQL_ROW row;
   int y;
   
   sql_data_seek(I->Res,++fd_Rec->ldata);
   if((row = sql_fetch_row(I->Res)) == NULL)
   {
      fl_set_object_lcol(fd_Rec->Next,FL_INACTIVE_COL);
      fd_Rec->ldata --;
      return;
   };
   
   for(y=0;y<I->Numflds;y++)
   {  /* fix v1.03 : avoid zero pointers being referenced */
      if(row[y] != NULL)
	fl_set_input(fd_Rec->Inputs[y],row[y]);
   }
   fl_set_object_lcol(fd_Rec->Previous,FL_BLACK);
}

void RecordChange(FL_OBJECT *ob, long parent)
{
   FD_Record *fd_Rec = (FD_Record *)parent;
   Info_t *I = (Info_t *)fd_Rec->vdata;
   SQL_ROW row;
   
   sql_data_seek(I->Res,fd_Rec->ldata);
   if((row = sql_fetch_row(I->Res)) == NULL)
   {
      SqlError("Cannot fetch record");
      return;
   };
   
   OpenRecordForModify(row[I->Primkey],I);
}
   
void RecordSearch(FL_OBJECT *ob, long parent)
{
   FD_Record *fd_Rec = (FD_Record *)parent;
   Info_t *I = (Info_t *)fd_Rec->vdata;   
   FD_Record *fd_Shw; /* Show form */
   Info_t    *R;      /* idem */
   char      **matchfields;
   char      query[MAXQUERY];
   int       y,v;

   matchfields=(char **)malloc(I->Numflds * sizeof(char *));

   sprintf(query,SELECT,I->Table);
   for(v=0, y=0; y< I->Numflds; y++)
   {
       if((matchfields[y] = (char *)malloc(I->Fields[y].length + 3)) == NULL)
      /* need extra room for 2 optional quotes (CHAR_TYPE) */
      {
	 SqlError("Malloc in RecordSearch failed !!");
	 exit(1);
      }
      *matchfields[y] = '\0';
      
      if(strlen(fl_get_input(fd_Rec->Inputs[y])) > 0)
      {
	 TypeConvert(matchfields[y],fl_get_input(fd_Rec->Inputs[y]),I->Fields[y].type);

	 if(v++ > 0)
	   strcat(query,AND);
	 else
	   strcat(query,WHERE);
	 sprintf(query + strlen(query),LIKE,I->Fields[y].name,matchfields[y]);
      }
   }
   
   /* Free up memory */
   for(y=0;y<I->Numflds;y++)
     free(matchfields[y]);
   free(matchfields);
   
   if (ExecuteQuery(I,query))
      return;
   
   I->Res = sql_store_result(sock);
   
   Info(I->Xsql,"%d Records found",sql_num_rows(I->Res));
   if(sql_num_rows(I->Res) == 0)
   {
      Message("No matching records found");
      return;
   }
   
   fd_Shw = BuildRecordForm(I,"Show Record",NEXBUT | PREBUT | CHGBUT);
   R      = (Info_t *)fd_Shw->vdata;

   for(y=0; y< I->Numflds; y++)
   {
      fl_deactivate_object(fd_Shw->Inputs[y]);
      fl_set_object_boxtype(fd_Shw->Inputs[y],FL_UP_BOX);
   }
   
   fd_Shw->ldata = -1; /* (ab)use as a counter ! */
   R->Res = I->Res;
   I->Res = 0;      /* avoid Res will be closed when fd_Rec closes */
   
   fl_call_object_callback(fd_Shw->Next);
   /* no need for search window anymore */
   fl_call_object_callback(fd_Rec->Close);
   
   /* Other ones can be shown through Next and Previous buttons */
}

void XsqlSearch(FL_OBJECT *ob, long parent)
{
   FD_Xsql *Xsql = (FD_Xsql *)parent;
   Info_t  *I    = (Info_t *) Xsql->vdata;
   
   if(CheckTableSelected((FD_Xsql *)parent) < 0)
     return;
   BuildRecordForm(I,"Search Form (Wildcards % or _ )",SEABUT);
}
