// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: stats.h,v 3.5 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_STATS_H

class Stats;

#else	// XSC_STATS_H
#define	XSC_STATS_H

#include "tthing.h"
#include "text.h"

enum stats_states {
    STATE_NORMAL,
    STATE_PAUSED,
    STATE_OVER
};

class Stats : public Tthing {
private:
    enum stats_states last_state;

    unsigned int last_score;
    int last_lives;

    Text text_score;
    Text text_state;

public:
    Stats(void);
    ~Stats(void);

    unsigned int score;
    int lives;
    enum stats_states state;

    void render(const bool);

    void reset(void);
    void resize(const int, const int);

    bool changed(void) const;
};


inline bool
Stats::changed(void) const
{
    return (score != last_score || lives != last_lives || state != last_state);
} // Stats::changed

#endif	// XSC_STATS_H
