// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: starfield.h,v 3.3 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_STARFIELD_H

class Stats;

#else	// XSC_STARFIELD_H
#define	XSC_STARFIELD_H

#include "castle.h"
#include "ship.h"

class Starfield : public Ething {
private:
    float starsize;
    struct coords *pts;
    int wander;

public:
    Starfield(const int, const bool);
    ~Starfield(void);

    void render(const bool, const Castle *, const Ship *);
    void draw(const Castle *, const Ship *);
    void erase(const Castle *, const Ship *);

    void move(void);
    void resize(const int, const int);
};

inline void
Starfield::draw(const Castle *castle, const Ship *ship)
{
    render(true, castle, ship);
} // Starfield::draw


inline void
Starfield::erase(const Castle *castle, const Ship *ship)
{
    render(false, castle, ship);
} // Starfield::erase

#endif	// XSC_STARFIELD_H
