// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: starfield.C,v 3.8 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "random.h"
#include "util.h"
#include "xsc.h"

#include "starfield.h"


Starfield::Starfield(const int number, const bool bright)
{
    //fprintf(stderr, "Starfield::Starfield()\n");
    int dim = (int)hypot(wwidth, gwheight);

    wander = dim / 2;
    dim += wander;

    x = wwidth2;
    y = gwheight2;

    num_points = number;
    pts = new coords[num_points];

    for (int i = 0; i < num_points; i++) {
	pts[i].x = (Random::get() % dim) - (dim / 2.0);
	pts[i].y = (Random::get() % dim) - (dim / 2.0);
    }
    points = pts;

    xpoints = new XPoint[num_points];

    starsize = wwidth / 200.0;
    set_size(1.0);

    set_gc(fetch_gc(bright ? GC_BRIGHT_GREY : GC_DULL_GREY));

    dx = 30 / args.fps;
    dy = -15 / args.fps;
    set_dtheta(50 / args.fps);
} // Starfield::Starfield


Starfield::~Starfield(void)
{
    //fprintf(stderr, "Starfield::~Starfield()\n");
    delete[] pts;
} // Starfield::~Starfield


void
Starfield::move(void)
{
    if ((x + dx) > wwidth2 + (wander / 2.0) ||
	    (x + dx) < wwidth2 - (wander / 2.0)) {
	dx = -dx;
    }
    if ((y + dy) > gwheight2 + (wander / 2.0) ||
	    (y + dy) < gwheight2 - (wander / 2.0)) {
	dy = -dy;
    }
    Xything::move();
} // Starfield::move


void
Starfield::render(const bool ink, const Castle *castle, const Ship *ship)
{
    GC thisgc;
    const float ringradius = castle->ring_size(CASTLE_RING_OUTER) / 2.0;
    const float shipradius = ship->get_diag();
    const float ship_x = ship->get_x();
    const float ship_y = ship->get_y();

    if (ink) {
	thisgc = gc;
	Tthing::set_xpoints();
    } else {
	thisgc = fetch_gc(GC_BLACK);
    }

    for (int i = 0; i < num_points; i++) {
	float sx = xpoints[i].x - (starsize / 2.0);
	float sy = xpoints[i].y - (starsize / 2.0);
	float castle_dist = hypot(wwidth2 - sx, gwheight2 - sy);
	float ship_dist = hypot(ship_x - sx, ship_y - sy);

	if ((!castle->alive() || castle_dist >= ringradius) &&
		(!ship->alive() || ship_dist >= shipradius)) {
	    XFillArc(display, window, thisgc, (int)sx, (int)sy,
		    (int)starsize, (int)starsize,
		    0, 360*64);
	}
    }
} // Starfield::render


void
Starfield::resize(const int nwidth, const int nheight)
{
    starsize *= (float)nwidth / wwidth;
    wander = (wander * nwidth) / wwidth;
    Xything::resize(nwidth, nheight);
} // Starfield::resize
