// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: ship.h,v 3.8 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_SHIP_H

class Ship;

#else	// XSC_SHIP_H
#define	XSC_SHIP_H

#include "castle.h"
#include "ething.h"
#include "king.h"
#include "laser.h"
#include "minefield.h"
#include "stats.h"
#include "xything.h"

const int NUM_SHIP_POINTS = 16;

extern const struct coords ship_points[NUM_SHIP_POINTS];


class Ship : public virtual Ething {
private:
    enum ship_states {
	SHIP_LIVING,
	SHIP_EXPLODING,
	SHIP_RESTING,
	SHIP_DEAD
    };
    enum ship_states state;

    bool user_rotating_cw;
    bool user_rotating_ccw;
    bool user_thrusting;
    int max_shots;
    Laser *lasers;
    Ething *segments;
    Stamp time_of_death;
    Stamp pause_start;
    Stamp pause_sum;
    coords *split_points;

    float initial_x(void);
    float initial_y(void);

    void bounce(Castle *);

public:
    Ship(void);
    ~Ship(void);

    void render(const bool);

    void move(Castle *, King *, Minefield *, Stats *);
    void turn(void);
    void fire(void) const;
    void resize(const int, const int);
    bool hit(Xything *);
    void reincarnate(void);

    void rotate_cw(const enum key_state);
    void rotate_ccw(const key_state);
    void thrust(const key_state);
    bool rotating_cw(void) const;
    bool rotating_ccw(void) const;
    bool thrusting(void) const;
    bool alive(void) const;
    void pause(const bool);
};


inline void
Ship::rotate_cw(const enum key_state n)
{
    user_rotating_cw = (n == KEY_DOWN);
} // Ship::rotate_cw


inline void
Ship::rotate_ccw(const key_state n)
{
    user_rotating_ccw = (n == KEY_DOWN);
} // Ship::rotate_ccw


inline void
Ship::thrust(const key_state n)
{
    user_thrusting = (n == KEY_DOWN);
} // Ship::thrust


inline bool
Ship::rotating_cw(void) const
{
    return user_rotating_cw;
} // Ship::rotating_cw


inline bool
Ship::rotating_ccw(void) const
{
    return user_rotating_ccw;
} // Ship::rotating_ccw


inline bool
Ship::thrusting(void) const
{
    return user_thrusting;
} // Ship::thrusting


inline bool
Ship::alive(void) const
{
    return (state == SHIP_LIVING);
} // Ship::alive


inline void
Ship::pause(const bool pause_state)
{
    if (pause_state) {
	pause_start = time_now;
    } else {
	pause_sum += time_now - pause_start;
    }
} // Ship::pause

#endif	// XSC_SHIP_H
