// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: romans.C,v 3.2 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "font.h"

namespace {

const coords x700[] = {
    { -0.01, -0.12 }, { -0.04, -0.11 },
    { -0.04, -0.11 }, { -0.06, -0.08 },
    { -0.06, -0.08 }, { -0.07, -0.03 },
    { -0.07, -0.03 }, { -0.07,  0.00 },
    { -0.07,  0.00 }, { -0.06,  0.05 },
    { -0.06,  0.05 }, { -0.04,  0.08 },
    { -0.04,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.01,  0.09 },
    {  0.01,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.05 },
    {  0.06,  0.05 }, {  0.07,  0.00 },
    {  0.07,  0.00 }, {  0.07, -0.03 },
    {  0.07, -0.03 }, {  0.06, -0.08 },
    {  0.06, -0.08 }, {  0.04, -0.11 },
    {  0.04, -0.11 }, {  0.01, -0.12 },
    {  0.01, -0.12 }, { -0.01, -0.12 },
};

const coords x701[] = {
    { -0.04, -0.08 }, { -0.02, -0.09 },
    { -0.02, -0.09 }, {  0.01, -0.12 },
    {  0.01, -0.12 }, {  0.01,  0.09 },
};

const coords x702[] = {
    { -0.06, -0.07 }, { -0.06, -0.08 },
    { -0.06, -0.08 }, { -0.05, -0.10 },
    { -0.05, -0.10 }, { -0.04, -0.11 },
    { -0.04, -0.11 }, { -0.02, -0.12 },
    { -0.02, -0.12 }, {  0.02, -0.12 },
    {  0.02, -0.12 }, {  0.04, -0.11 },
    {  0.04, -0.11 }, {  0.05, -0.10 },
    {  0.05, -0.10 }, {  0.06, -0.08 },
    {  0.06, -0.08 }, {  0.06, -0.06 },
    {  0.06, -0.06 }, {  0.05, -0.04 },
    {  0.05, -0.04 }, {  0.03, -0.01 },
    {  0.03, -0.01 }, { -0.07,  0.09 },
    { -0.07,  0.09 }, {  0.07,  0.09 },
};

const coords x703[] = {
    { -0.05, -0.12 }, {  0.06, -0.12 },
    {  0.06, -0.12 }, {  0.00, -0.04 },
    {  0.00, -0.04 }, {  0.03, -0.04 },
    {  0.03, -0.04 }, {  0.05, -0.03 },
    {  0.05, -0.03 }, {  0.06, -0.02 },
    {  0.06, -0.02 }, {  0.07,  0.01 },
    {  0.07,  0.01 }, {  0.07,  0.03 },
    {  0.07,  0.03 }, {  0.06,  0.06 },
    {  0.06,  0.06 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.01,  0.09 },
    {  0.01,  0.09 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, { -0.05,  0.08 },
    { -0.05,  0.08 }, { -0.06,  0.07 },
    { -0.06,  0.07 }, { -0.07,  0.05 },
};

const coords x704[] = {
    {  0.03, -0.12 }, { -0.07,  0.02 },
    { -0.07,  0.02 }, {  0.08,  0.02 },
    {  0.03, -0.12 }, {  0.03,  0.09 },
};

const coords x705[] = {
    {  0.05, -0.12 }, { -0.05, -0.12 },
    { -0.05, -0.12 }, { -0.06, -0.03 },
    { -0.06, -0.03 }, { -0.05, -0.04 },
    { -0.05, -0.04 }, { -0.02, -0.05 },
    { -0.02, -0.05 }, {  0.01, -0.05 },
    {  0.01, -0.05 }, {  0.04, -0.04 },
    {  0.04, -0.04 }, {  0.06, -0.02 },
    {  0.06, -0.02 }, {  0.07,  0.01 },
    {  0.07,  0.01 }, {  0.07,  0.03 },
    {  0.07,  0.03 }, {  0.06,  0.06 },
    {  0.06,  0.06 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.01,  0.09 },
    {  0.01,  0.09 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, { -0.05,  0.08 },
    { -0.05,  0.08 }, { -0.06,  0.07 },
    { -0.06,  0.07 }, { -0.07,  0.05 },
};

const coords x706[] = {
    {  0.06, -0.09 }, {  0.05, -0.11 },
    {  0.05, -0.11 }, {  0.02, -0.12 },
    {  0.02, -0.12 }, {  0.00, -0.12 },
    {  0.00, -0.12 }, { -0.03, -0.11 },
    { -0.03, -0.11 }, { -0.05, -0.08 },
    { -0.05, -0.08 }, { -0.06, -0.03 },
    { -0.06, -0.03 }, { -0.06,  0.02 },
    { -0.06,  0.02 }, { -0.05,  0.06 },
    { -0.05,  0.06 }, { -0.03,  0.08 },
    { -0.03,  0.08 }, {  0.00,  0.09 },
    {  0.00,  0.09 }, {  0.01,  0.09 },
    {  0.01,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
    {  0.06,  0.06 }, {  0.07,  0.03 },
    {  0.07,  0.03 }, {  0.07,  0.02 },
    {  0.07,  0.02 }, {  0.06, -0.01 },
    {  0.06, -0.01 }, {  0.04, -0.03 },
    {  0.04, -0.03 }, {  0.01, -0.04 },
    {  0.01, -0.04 }, {  0.00, -0.04 },
    {  0.00, -0.04 }, { -0.03, -0.03 },
    { -0.03, -0.03 }, { -0.05, -0.01 },
    { -0.05, -0.01 }, { -0.06,  0.02 },
};

const coords x707[] = {
    {  0.07, -0.12 }, { -0.03,  0.09 },
    { -0.07, -0.12 }, {  0.07, -0.12 },
};

const coords x708[] = {
    { -0.02, -0.12 }, { -0.05, -0.11 },
    { -0.05, -0.11 }, { -0.06, -0.09 },
    { -0.06, -0.09 }, { -0.06, -0.07 },
    { -0.06, -0.07 }, { -0.05, -0.05 },
    { -0.05, -0.05 }, { -0.03, -0.04 },
    { -0.03, -0.04 }, {  0.01, -0.03 },
    {  0.01, -0.03 }, {  0.04, -0.02 },
    {  0.04, -0.02 }, {  0.06,  0.00 },
    {  0.06,  0.00 }, {  0.07,  0.02 },
    {  0.07,  0.02 }, {  0.07,  0.05 },
    {  0.07,  0.05 }, {  0.06,  0.07 },
    {  0.06,  0.07 }, {  0.05,  0.08 },
    {  0.05,  0.08 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, { -0.05,  0.08 },
    { -0.05,  0.08 }, { -0.06,  0.07 },
    { -0.06,  0.07 }, { -0.07,  0.05 },
    { -0.07,  0.05 }, { -0.07,  0.02 },
    { -0.07,  0.02 }, { -0.06,  0.00 },
    { -0.06,  0.00 }, { -0.04, -0.02 },
    { -0.04, -0.02 }, { -0.01, -0.03 },
    { -0.01, -0.03 }, {  0.03, -0.04 },
    {  0.03, -0.04 }, {  0.05, -0.05 },
    {  0.05, -0.05 }, {  0.06, -0.07 },
    {  0.06, -0.07 }, {  0.06, -0.09 },
    {  0.06, -0.09 }, {  0.05, -0.11 },
    {  0.05, -0.11 }, {  0.02, -0.12 },
    {  0.02, -0.12 }, { -0.02, -0.12 },
};

const coords x709[] = {
    {  0.06, -0.05 }, {  0.05, -0.02 },
    {  0.05, -0.02 }, {  0.03,  0.00 },
    {  0.03,  0.00 }, {  0.00,  0.01 },
    {  0.00,  0.01 }, { -0.01,  0.01 },
    { -0.01,  0.01 }, { -0.04,  0.00 },
    { -0.04,  0.00 }, { -0.06, -0.02 },
    { -0.06, -0.02 }, { -0.07, -0.05 },
    { -0.07, -0.05 }, { -0.07, -0.06 },
    { -0.07, -0.06 }, { -0.06, -0.09 },
    { -0.06, -0.09 }, { -0.04, -0.11 },
    { -0.04, -0.11 }, { -0.01, -0.12 },
    { -0.01, -0.12 }, {  0.00, -0.12 },
    {  0.00, -0.12 }, {  0.03, -0.11 },
    {  0.03, -0.11 }, {  0.05, -0.09 },
    {  0.05, -0.09 }, {  0.06, -0.05 },
    {  0.06, -0.05 }, {  0.06,  0.00 },
    {  0.06,  0.00 }, {  0.05,  0.05 },
    {  0.05,  0.05 }, {  0.03,  0.08 },
    {  0.03,  0.08 }, {  0.00,  0.09 },
    {  0.00,  0.09 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, { -0.05,  0.08 },
    { -0.05,  0.08 }, { -0.06,  0.06 },
};

const coords x711[] = {
    {  0.01,  0.08 }, {  0.00,  0.09 },
    {  0.00,  0.09 }, { -0.01,  0.08 },
    { -0.01,  0.08 }, {  0.00,  0.07 },
    {  0.00,  0.07 }, {  0.01,  0.08 },
    {  0.01,  0.08 }, {  0.01,  0.10 },
    {  0.01,  0.10 }, {  0.00,  0.12 },
    {  0.00,  0.12 }, { -0.01,  0.13 },
};
const coords x501[] = {
    {  0.00, -0.12 }, { -0.08,  0.09 },
    {  0.00, -0.12 }, {  0.08,  0.09 },
    { -0.05,  0.02 }, {  0.05,  0.02 },
};

const coords x502[] = {
    { -0.07, -0.12 }, { -0.07,  0.09 },
    { -0.07, -0.12 }, {  0.02, -0.12 },
    {  0.02, -0.12 }, {  0.05, -0.11 },
    {  0.05, -0.11 }, {  0.06, -0.10 },
    {  0.06, -0.10 }, {  0.07, -0.08 },
    {  0.07, -0.08 }, {  0.07, -0.06 },
    {  0.07, -0.06 }, {  0.06, -0.04 },
    {  0.06, -0.04 }, {  0.05, -0.03 },
    {  0.05, -0.03 }, {  0.02, -0.02 },
    { -0.07, -0.02 }, {  0.02, -0.02 },
    {  0.02, -0.02 }, {  0.05, -0.01 },
    {  0.05, -0.01 }, {  0.06,  0.00 },
    {  0.06,  0.00 }, {  0.07,  0.02 },
    {  0.07,  0.02 }, {  0.07,  0.05 },
    {  0.07,  0.05 }, {  0.06,  0.07 },
    {  0.06,  0.07 }, {  0.05,  0.08 },
    {  0.05,  0.08 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, { -0.07,  0.09 },
};

const coords x503[] = {
    {  0.08, -0.07 }, {  0.07, -0.09 },
    {  0.07, -0.09 }, {  0.05, -0.11 },
    {  0.05, -0.11 }, {  0.03, -0.12 },
    {  0.03, -0.12 }, { -0.01, -0.12 },
    { -0.01, -0.12 }, { -0.03, -0.11 },
    { -0.03, -0.11 }, { -0.05, -0.09 },
    { -0.05, -0.09 }, { -0.06, -0.07 },
    { -0.06, -0.07 }, { -0.07, -0.04 },
    { -0.07, -0.04 }, { -0.07,  0.01 },
    { -0.07,  0.01 }, { -0.06,  0.04 },
    { -0.06,  0.04 }, { -0.05,  0.06 },
    { -0.05,  0.06 }, { -0.03,  0.08 },
    { -0.03,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.03,  0.09 },
    {  0.03,  0.09 }, {  0.05,  0.08 },
    {  0.05,  0.08 }, {  0.07,  0.06 },
    {  0.07,  0.06 }, {  0.08,  0.04 },
};

const coords x504[] = {
    { -0.07, -0.12 }, { -0.07,  0.09 },
    { -0.07, -0.12 }, {  0.00, -0.12 },
    {  0.00, -0.12 }, {  0.03, -0.11 },
    {  0.03, -0.11 }, {  0.05, -0.09 },
    {  0.05, -0.09 }, {  0.06, -0.07 },
    {  0.06, -0.07 }, {  0.07, -0.04 },
    {  0.07, -0.04 }, {  0.07,  0.01 },
    {  0.07,  0.01 }, {  0.06,  0.04 },
    {  0.06,  0.04 }, {  0.05,  0.06 },
    {  0.05,  0.06 }, {  0.03,  0.08 },
    {  0.03,  0.08 }, {  0.00,  0.09 },
    {  0.00,  0.09 }, { -0.07,  0.09 },
};

const coords x505[] = {
    { -0.06, -0.12 }, { -0.06,  0.09 },
    { -0.06, -0.12 }, {  0.07, -0.12 },
    { -0.06, -0.02 }, {  0.02, -0.02 },
    { -0.06,  0.09 }, {  0.07,  0.09 },
};

const coords x506[] = {
    { -0.06, -0.12 }, { -0.06,  0.09 },
    { -0.06, -0.12 }, {  0.07, -0.12 },
    { -0.06, -0.02 }, {  0.02, -0.02 },
};

const coords x507[] = {
    {  0.08, -0.07 }, {  0.07, -0.09 },
    {  0.07, -0.09 }, {  0.05, -0.11 },
    {  0.05, -0.11 }, {  0.03, -0.12 },
    {  0.03, -0.12 }, { -0.01, -0.12 },
    { -0.01, -0.12 }, { -0.03, -0.11 },
    { -0.03, -0.11 }, { -0.05, -0.09 },
    { -0.05, -0.09 }, { -0.06, -0.07 },
    { -0.06, -0.07 }, { -0.07, -0.04 },
    { -0.07, -0.04 }, { -0.07,  0.01 },
    { -0.07,  0.01 }, { -0.06,  0.04 },
    { -0.06,  0.04 }, { -0.05,  0.06 },
    { -0.05,  0.06 }, { -0.03,  0.08 },
    { -0.03,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.03,  0.09 },
    {  0.03,  0.09 }, {  0.05,  0.08 },
    {  0.05,  0.08 }, {  0.07,  0.06 },
    {  0.07,  0.06 }, {  0.08,  0.04 },
    {  0.08,  0.04 }, {  0.08,  0.01 },
    {  0.03,  0.01 }, {  0.08,  0.01 },
};

const coords x508[] = {
    { -0.07, -0.12 }, { -0.07,  0.09 },
    {  0.07, -0.12 }, {  0.07,  0.09 },
    { -0.07, -0.02 }, {  0.07, -0.02 },
};

const coords x509[] = {
    {  0.00, -0.12 }, {  0.00,  0.09 },
};

const coords x510[] = {
    {  0.04, -0.12 }, {  0.04,  0.04 },
    {  0.04,  0.04 }, {  0.03,  0.07 },
    {  0.03,  0.07 }, {  0.02,  0.08 },
    {  0.02,  0.08 }, {  0.00,  0.09 },
    {  0.00,  0.09 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, { -0.04,  0.08 },
    { -0.04,  0.08 }, { -0.05,  0.07 },
    { -0.05,  0.07 }, { -0.06,  0.04 },
    { -0.06,  0.04 }, { -0.06,  0.02 },
};

const coords x511[] = {
    { -0.07, -0.12 }, { -0.07,  0.09 },
    {  0.07, -0.12 }, { -0.07,  0.02 },
    { -0.02, -0.03 }, {  0.07,  0.09 },
};

const coords x512[] = {
    { -0.06, -0.12 }, { -0.06,  0.09 },
    { -0.06,  0.09 }, {  0.06,  0.09 },
};

const coords x513[] = {
    { -0.08, -0.12 }, { -0.08,  0.09 },
    { -0.08, -0.12 }, {  0.00,  0.09 },
    {  0.08, -0.12 }, {  0.00,  0.09 },
    {  0.08, -0.12 }, {  0.08,  0.09 },
};

const coords x514[] = {
    { -0.07, -0.12 }, { -0.07,  0.09 },
    { -0.07, -0.12 }, {  0.07,  0.09 },
    {  0.07, -0.12 }, {  0.07,  0.09 },
};

const coords x515[] = {
    { -0.02, -0.12 }, { -0.04, -0.11 },
    { -0.04, -0.11 }, { -0.06, -0.09 },
    { -0.06, -0.09 }, { -0.07, -0.07 },
    { -0.07, -0.07 }, { -0.08, -0.04 },
    { -0.08, -0.04 }, { -0.08,  0.01 },
    { -0.08,  0.01 }, { -0.07,  0.04 },
    { -0.07,  0.04 }, { -0.06,  0.06 },
    { -0.06,  0.06 }, { -0.04,  0.08 },
    { -0.04,  0.08 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
    {  0.06,  0.06 }, {  0.07,  0.04 },
    {  0.07,  0.04 }, {  0.08,  0.01 },
    {  0.08,  0.01 }, {  0.08, -0.04 },
    {  0.08, -0.04 }, {  0.07, -0.07 },
    {  0.07, -0.07 }, {  0.06, -0.09 },
    {  0.06, -0.09 }, {  0.04, -0.11 },
    {  0.04, -0.11 }, {  0.02, -0.12 },
    {  0.02, -0.12 }, { -0.02, -0.12 },
};

const coords x516[] = {
    { -0.07, -0.12 }, { -0.07,  0.09 },
    { -0.07, -0.12 }, {  0.02, -0.12 },
    {  0.02, -0.12 }, {  0.05, -0.11 },
    {  0.05, -0.11 }, {  0.06, -0.10 },
    {  0.06, -0.10 }, {  0.07, -0.08 },
    {  0.07, -0.08 }, {  0.07, -0.05 },
    {  0.07, -0.05 }, {  0.06, -0.03 },
    {  0.06, -0.03 }, {  0.05, -0.02 },
    {  0.05, -0.02 }, {  0.02, -0.01 },
    {  0.02, -0.01 }, { -0.07, -0.01 },
};

const coords x517[] = {
    { -0.02, -0.12 }, { -0.04, -0.11 },
    { -0.04, -0.11 }, { -0.06, -0.09 },
    { -0.06, -0.09 }, { -0.07, -0.07 },
    { -0.07, -0.07 }, { -0.08, -0.04 },
    { -0.08, -0.04 }, { -0.08,  0.01 },
    { -0.08,  0.01 }, { -0.07,  0.04 },
    { -0.07,  0.04 }, { -0.06,  0.06 },
    { -0.06,  0.06 }, { -0.04,  0.08 },
    { -0.04,  0.08 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
    {  0.06,  0.06 }, {  0.07,  0.04 },
    {  0.07,  0.04 }, {  0.08,  0.01 },
    {  0.08,  0.01 }, {  0.08, -0.04 },
    {  0.08, -0.04 }, {  0.07, -0.07 },
    {  0.07, -0.07 }, {  0.06, -0.09 },
    {  0.06, -0.09 }, {  0.04, -0.11 },
    {  0.04, -0.11 }, {  0.02, -0.12 },
    {  0.02, -0.12 }, { -0.02, -0.12 },
    {  0.01,  0.05 }, {  0.07,  0.11 },
};

const coords x518[] = {
    { -0.07, -0.12 }, { -0.07,  0.09 },
    { -0.07, -0.12 }, {  0.02, -0.12 },
    {  0.02, -0.12 }, {  0.05, -0.11 },
    {  0.05, -0.11 }, {  0.06, -0.10 },
    {  0.06, -0.10 }, {  0.07, -0.08 },
    {  0.07, -0.08 }, {  0.07, -0.06 },
    {  0.07, -0.06 }, {  0.06, -0.04 },
    {  0.06, -0.04 }, {  0.05, -0.03 },
    {  0.05, -0.03 }, {  0.02, -0.02 },
    {  0.02, -0.02 }, { -0.07, -0.02 },
    {  0.00, -0.02 }, {  0.07,  0.09 },
};

const coords x519[] = {
    {  0.07, -0.09 }, {  0.05, -0.11 },
    {  0.05, -0.11 }, {  0.02, -0.12 },
    {  0.02, -0.12 }, { -0.02, -0.12 },
    { -0.02, -0.12 }, { -0.05, -0.11 },
    { -0.05, -0.11 }, { -0.07, -0.09 },
    { -0.07, -0.09 }, { -0.07, -0.07 },
    { -0.07, -0.07 }, { -0.06, -0.05 },
    { -0.06, -0.05 }, { -0.05, -0.04 },
    { -0.05, -0.04 }, { -0.03, -0.03 },
    { -0.03, -0.03 }, {  0.03, -0.01 },
    {  0.03, -0.01 }, {  0.05,  0.00 },
    {  0.05,  0.00 }, {  0.06,  0.01 },
    {  0.06,  0.01 }, {  0.07,  0.03 },
    {  0.07,  0.03 }, {  0.07,  0.06 },
    {  0.07,  0.06 }, {  0.05,  0.08 },
    {  0.05,  0.08 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, { -0.05,  0.08 },
    { -0.05,  0.08 }, { -0.07,  0.06 },
};

const coords x520[] = {
    {  0.00, -0.12 }, {  0.00,  0.09 },
    { -0.07, -0.12 }, {  0.07, -0.12 },
};

const coords x521[] = {
    { -0.07, -0.12 }, { -0.07,  0.03 },
    { -0.07,  0.03 }, { -0.06,  0.06 },
    { -0.06,  0.06 }, { -0.04,  0.08 },
    { -0.04,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.01,  0.09 },
    {  0.01,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
    {  0.06,  0.06 }, {  0.07,  0.03 },
    {  0.07,  0.03 }, {  0.07, -0.12 },
};

const coords x522[] = {
    { -0.08, -0.12 }, {  0.00,  0.09 },
    {  0.08, -0.12 }, {  0.00,  0.09 },
};

const coords x523[] = {
    { -0.10, -0.12 }, { -0.05,  0.09 },
    {  0.00, -0.12 }, { -0.05,  0.09 },
    {  0.00, -0.12 }, {  0.05,  0.09 },
    {  0.10, -0.12 }, {  0.05,  0.09 },
};

const coords x524[] = {
    { -0.07, -0.12 }, {  0.07,  0.09 },
    {  0.07, -0.12 }, { -0.07,  0.09 },
};

const coords x525[] = {
    { -0.08, -0.12 }, {  0.00, -0.02 },
    {  0.00, -0.02 }, {  0.00,  0.09 },
    {  0.08, -0.12 }, {  0.00, -0.02 },
};

const coords x526[] = {
    {  0.07, -0.12 }, { -0.07,  0.09 },
    { -0.07, -0.12 }, {  0.07, -0.12 },
    { -0.07,  0.09 }, {  0.07,  0.09 },
};

const coords x601[] = {
    {  0.06, -0.05 }, {  0.06,  0.09 },
    {  0.06, -0.02 }, {  0.04, -0.04 },
    {  0.04, -0.04 }, {  0.02, -0.05 },
    {  0.02, -0.05 }, { -0.01, -0.05 },
    { -0.01, -0.05 }, { -0.03, -0.04 },
    { -0.03, -0.04 }, { -0.05, -0.02 },
    { -0.05, -0.02 }, { -0.06,  0.01 },
    { -0.06,  0.01 }, { -0.06,  0.03 },
    { -0.06,  0.03 }, { -0.05,  0.06 },
    { -0.05,  0.06 }, { -0.03,  0.08 },
    { -0.03,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
};

const coords x602[] = {
    { -0.06, -0.12 }, { -0.06,  0.09 },
    { -0.06, -0.02 }, { -0.04, -0.04 },
    { -0.04, -0.04 }, { -0.02, -0.05 },
    { -0.02, -0.05 }, {  0.01, -0.05 },
    {  0.01, -0.05 }, {  0.03, -0.04 },
    {  0.03, -0.04 }, {  0.05, -0.02 },
    {  0.05, -0.02 }, {  0.06,  0.01 },
    {  0.06,  0.01 }, {  0.06,  0.03 },
    {  0.06,  0.03 }, {  0.05,  0.06 },
    {  0.05,  0.06 }, {  0.03,  0.08 },
    {  0.03,  0.08 }, {  0.01,  0.09 },
    {  0.01,  0.09 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, { -0.04,  0.08 },
    { -0.04,  0.08 }, { -0.06,  0.06 },
};

const coords x603[] = {
    {  0.06, -0.02 }, {  0.04, -0.04 },
    {  0.04, -0.04 }, {  0.02, -0.05 },
    {  0.02, -0.05 }, { -0.01, -0.05 },
    { -0.01, -0.05 }, { -0.03, -0.04 },
    { -0.03, -0.04 }, { -0.05, -0.02 },
    { -0.05, -0.02 }, { -0.06,  0.01 },
    { -0.06,  0.01 }, { -0.06,  0.03 },
    { -0.06,  0.03 }, { -0.05,  0.06 },
    { -0.05,  0.06 }, { -0.03,  0.08 },
    { -0.03,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
};

const coords x604[] = {
    {  0.06, -0.12 }, {  0.06,  0.09 },
    {  0.06, -0.02 }, {  0.04, -0.04 },
    {  0.04, -0.04 }, {  0.02, -0.05 },
    {  0.02, -0.05 }, { -0.01, -0.05 },
    { -0.01, -0.05 }, { -0.03, -0.04 },
    { -0.03, -0.04 }, { -0.05, -0.02 },
    { -0.05, -0.02 }, { -0.06,  0.01 },
    { -0.06,  0.01 }, { -0.06,  0.03 },
    { -0.06,  0.03 }, { -0.05,  0.06 },
    { -0.05,  0.06 }, { -0.03,  0.08 },
    { -0.03,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
};

const coords x605[] = {
    { -0.06,  0.01 }, {  0.06,  0.01 },
    {  0.06,  0.01 }, {  0.06, -0.01 },
    {  0.06, -0.01 }, {  0.05, -0.03 },
    {  0.05, -0.03 }, {  0.04, -0.04 },
    {  0.04, -0.04 }, {  0.02, -0.05 },
    {  0.02, -0.05 }, { -0.01, -0.05 },
    { -0.01, -0.05 }, { -0.03, -0.04 },
    { -0.03, -0.04 }, { -0.05, -0.02 },
    { -0.05, -0.02 }, { -0.06,  0.01 },
    { -0.06,  0.01 }, { -0.06,  0.03 },
    { -0.06,  0.03 }, { -0.05,  0.06 },
    { -0.05,  0.06 }, { -0.03,  0.08 },
    { -0.03,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
};

const coords x606[] = {
    {  0.05, -0.12 }, {  0.03, -0.12 },
    {  0.03, -0.12 }, {  0.01, -0.11 },
    {  0.01, -0.11 }, {  0.00, -0.08 },
    {  0.00, -0.08 }, {  0.00,  0.09 },
    { -0.03, -0.05 }, {  0.04, -0.05 },
};

const coords x607[] = {
    {  0.06, -0.05 }, {  0.06,  0.11 },
    {  0.06,  0.11 }, {  0.05,  0.14 },
    {  0.05,  0.14 }, {  0.04,  0.15 },
    {  0.04,  0.15 }, {  0.02,  0.16 },
    {  0.02,  0.16 }, { -0.01,  0.16 },
    { -0.01,  0.16 }, { -0.03,  0.15 },
    {  0.06, -0.02 }, {  0.04, -0.04 },
    {  0.04, -0.04 }, {  0.02, -0.05 },
    {  0.02, -0.05 }, { -0.01, -0.05 },
    { -0.01, -0.05 }, { -0.03, -0.04 },
    { -0.03, -0.04 }, { -0.05, -0.02 },
    { -0.05, -0.02 }, { -0.06,  0.01 },
    { -0.06,  0.01 }, { -0.06,  0.03 },
    { -0.06,  0.03 }, { -0.05,  0.06 },
    { -0.05,  0.06 }, { -0.03,  0.08 },
    { -0.03,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
};

const coords x608[] = {
    { -0.05, -0.12 }, { -0.05,  0.09 },
    { -0.05, -0.01 }, { -0.02, -0.04 },
    { -0.02, -0.04 }, {  0.00, -0.05 },
    {  0.00, -0.05 }, {  0.03, -0.05 },
    {  0.03, -0.05 }, {  0.05, -0.04 },
    {  0.05, -0.04 }, {  0.06, -0.01 },
    {  0.06, -0.01 }, {  0.06,  0.09 },
};

const coords x609[] = {
    { -0.01, -0.12 }, {  0.00, -0.11 },
    {  0.00, -0.11 }, {  0.01, -0.12 },
    {  0.01, -0.12 }, {  0.00, -0.13 },
    {  0.00, -0.13 }, { -0.01, -0.12 },
    {  0.00, -0.05 }, {  0.00,  0.09 },
};

const coords x610[] = {
    {  0.00, -0.12 }, {  0.01, -0.11 },
    {  0.01, -0.11 }, {  0.02, -0.12 },
    {  0.02, -0.12 }, {  0.01, -0.13 },
    {  0.01, -0.13 }, {  0.00, -0.12 },
    {  0.01, -0.05 }, {  0.01,  0.12 },
    {  0.01,  0.12 }, {  0.00,  0.15 },
    {  0.00,  0.15 }, { -0.02,  0.16 },
    { -0.02,  0.16 }, { -0.04,  0.16 },
};

const coords x611[] = {
    { -0.05, -0.12 }, { -0.05,  0.09 },
    {  0.05, -0.05 }, { -0.05,  0.05 },
    { -0.01,  0.01 }, {  0.06,  0.09 },
};

const coords x612[] = {
    {  0.00, -0.12 }, {  0.00,  0.09 },
};

const coords x613[] = {
    { -0.11, -0.05 }, { -0.11,  0.09 },
    { -0.11, -0.01 }, { -0.08, -0.04 },
    { -0.08, -0.04 }, { -0.06, -0.05 },
    { -0.06, -0.05 }, { -0.03, -0.05 },
    { -0.03, -0.05 }, { -0.01, -0.04 },
    { -0.01, -0.04 }, {  0.00, -0.01 },
    {  0.00, -0.01 }, {  0.00,  0.09 },
    {  0.00, -0.01 }, {  0.03, -0.04 },
    {  0.03, -0.04 }, {  0.05, -0.05 },
    {  0.05, -0.05 }, {  0.08, -0.05 },
    {  0.08, -0.05 }, {  0.10, -0.04 },
    {  0.10, -0.04 }, {  0.11, -0.01 },
    {  0.11, -0.01 }, {  0.11,  0.09 },
};

const coords x614[] = {
    { -0.05, -0.05 }, { -0.05,  0.09 },
    { -0.05, -0.01 }, { -0.02, -0.04 },
    { -0.02, -0.04 }, {  0.00, -0.05 },
    {  0.00, -0.05 }, {  0.03, -0.05 },
    {  0.03, -0.05 }, {  0.05, -0.04 },
    {  0.05, -0.04 }, {  0.06, -0.01 },
    {  0.06, -0.01 }, {  0.06,  0.09 },
};

const coords x615[] = {
    { -0.01, -0.05 }, { -0.03, -0.04 },
    { -0.03, -0.04 }, { -0.05, -0.02 },
    { -0.05, -0.02 }, { -0.06,  0.01 },
    { -0.06,  0.01 }, { -0.06,  0.03 },
    { -0.06,  0.03 }, { -0.05,  0.06 },
    { -0.05,  0.06 }, { -0.03,  0.08 },
    { -0.03,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
    {  0.06,  0.06 }, {  0.07,  0.03 },
    {  0.07,  0.03 }, {  0.07,  0.01 },
    {  0.07,  0.01 }, {  0.06, -0.02 },
    {  0.06, -0.02 }, {  0.04, -0.04 },
    {  0.04, -0.04 }, {  0.02, -0.05 },
    {  0.02, -0.05 }, { -0.01, -0.05 },
};

const coords x616[] = {
    { -0.06, -0.05 }, { -0.06,  0.16 },
    { -0.06, -0.02 }, { -0.04, -0.04 },
    { -0.04, -0.04 }, { -0.02, -0.05 },
    { -0.02, -0.05 }, {  0.01, -0.05 },
    {  0.01, -0.05 }, {  0.03, -0.04 },
    {  0.03, -0.04 }, {  0.05, -0.02 },
    {  0.05, -0.02 }, {  0.06,  0.01 },
    {  0.06,  0.01 }, {  0.06,  0.03 },
    {  0.06,  0.03 }, {  0.05,  0.06 },
    {  0.05,  0.06 }, {  0.03,  0.08 },
    {  0.03,  0.08 }, {  0.01,  0.09 },
    {  0.01,  0.09 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, { -0.04,  0.08 },
    { -0.04,  0.08 }, { -0.06,  0.06 },
};

const coords x617[] = {
    {  0.06, -0.05 }, {  0.06,  0.16 },
    {  0.06, -0.02 }, {  0.04, -0.04 },
    {  0.04, -0.04 }, {  0.02, -0.05 },
    {  0.02, -0.05 }, { -0.01, -0.05 },
    { -0.01, -0.05 }, { -0.03, -0.04 },
    { -0.03, -0.04 }, { -0.05, -0.02 },
    { -0.05, -0.02 }, { -0.06,  0.01 },
    { -0.06,  0.01 }, { -0.06,  0.03 },
    { -0.06,  0.03 }, { -0.05,  0.06 },
    { -0.05,  0.06 }, { -0.03,  0.08 },
    { -0.03,  0.08 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, {  0.04,  0.08 },
    {  0.04,  0.08 }, {  0.06,  0.06 },
};

const coords x618[] = {
    { -0.03, -0.05 }, { -0.03,  0.09 },
    { -0.03,  0.01 }, { -0.02, -0.02 },
    { -0.02, -0.02 }, {  0.00, -0.04 },
    {  0.00, -0.04 }, {  0.02, -0.05 },
    {  0.02, -0.05 }, {  0.05, -0.05 },
};

const coords x619[] = {
    {  0.06, -0.02 }, {  0.05, -0.04 },
    {  0.05, -0.04 }, {  0.02, -0.05 },
    {  0.02, -0.05 }, { -0.01, -0.05 },
    { -0.01, -0.05 }, { -0.04, -0.04 },
    { -0.04, -0.04 }, { -0.05, -0.02 },
    { -0.05, -0.02 }, { -0.04,  0.00 },
    { -0.04,  0.00 }, { -0.02,  0.01 },
    { -0.02,  0.01 }, {  0.03,  0.02 },
    {  0.03,  0.02 }, {  0.05,  0.03 },
    {  0.05,  0.03 }, {  0.06,  0.05 },
    {  0.06,  0.05 }, {  0.06,  0.06 },
    {  0.06,  0.06 }, {  0.05,  0.08 },
    {  0.05,  0.08 }, {  0.02,  0.09 },
    {  0.02,  0.09 }, { -0.01,  0.09 },
    { -0.01,  0.09 }, { -0.04,  0.08 },
    { -0.04,  0.08 }, { -0.05,  0.06 },
};

const coords x620[] = {
    {  0.00, -0.12 }, {  0.00,  0.05 },
    {  0.00,  0.05 }, {  0.01,  0.08 },
    {  0.01,  0.08 }, {  0.03,  0.09 },
    {  0.03,  0.09 }, {  0.05,  0.09 },
    { -0.03, -0.05 }, {  0.04, -0.05 },
};

const coords x621[] = {
    { -0.05, -0.05 }, { -0.05,  0.05 },
    { -0.05,  0.05 }, { -0.04,  0.08 },
    { -0.04,  0.08 }, { -0.02,  0.09 },
    { -0.02,  0.09 }, {  0.01,  0.09 },
    {  0.01,  0.09 }, {  0.03,  0.08 },
    {  0.03,  0.08 }, {  0.06,  0.05 },
    {  0.06, -0.05 }, {  0.06,  0.09 },
};

const coords x622[] = {
    { -0.06, -0.05 }, {  0.00,  0.09 },
    {  0.06, -0.05 }, {  0.00,  0.09 },
};

const coords x623[] = {
    { -0.08, -0.05 }, { -0.04,  0.09 },
    {  0.00, -0.05 }, { -0.04,  0.09 },
    {  0.00, -0.05 }, {  0.04,  0.09 },
    {  0.08, -0.05 }, {  0.04,  0.09 },
};

const coords x624[] = {
    { -0.05, -0.05 }, {  0.06,  0.09 },
    {  0.06, -0.05 }, { -0.05,  0.09 },
};

const coords x625[] = {
    { -0.06, -0.05 }, {  0.00,  0.09 },
    {  0.06, -0.05 }, {  0.00,  0.09 },
    {  0.00,  0.09 }, { -0.02,  0.13 },
    { -0.02,  0.13 }, { -0.04,  0.15 },
    { -0.04,  0.15 }, { -0.06,  0.16 },
    { -0.06,  0.16 }, { -0.07,  0.16 },
};

const coords x626[] = {
    {  0.06, -0.05 }, { -0.05,  0.09 },
    { -0.05, -0.05 }, {  0.06, -0.05 },
    { -0.05,  0.09 }, {  0.06,  0.09 },
};

} // namespace

const coords *const romans_points[] = {
    x700, x701, x702, x703, x704,	// 0-9
    x705, x706, x707, x708, x709,

    x711,				// ,

    x501, x502, x503, x504, x505,	// A-Z
    x506, x507, x508, x509, x510,
    x511, x512, x513, x514, x515,
    x516, x517, x518, x519, x520,
    x521, x522, x523, x524, x525,
    x526,

    x601, x602, x603, x604, x605,	// a-z
    x606, x607, x608, x609, x610,
    x611, x612, x613, x614, x615,
    x616, x617, x618, x619, x620,
    x621, x622, x623, x624, x625,
    x626
};

const int romans_count[] = {
    sizeof(x700) / sizeof(coords),
    sizeof(x701) / sizeof(coords),
    sizeof(x702) / sizeof(coords),
    sizeof(x703) / sizeof(coords),
    sizeof(x704) / sizeof(coords),
    sizeof(x705) / sizeof(coords),
    sizeof(x706) / sizeof(coords),
    sizeof(x707) / sizeof(coords),
    sizeof(x708) / sizeof(coords),
    sizeof(x709) / sizeof(coords),

    sizeof(x711) / sizeof(coords),

    sizeof(x501) / sizeof(coords),
    sizeof(x502) / sizeof(coords),
    sizeof(x503) / sizeof(coords),
    sizeof(x504) / sizeof(coords),
    sizeof(x505) / sizeof(coords),
    sizeof(x506) / sizeof(coords),
    sizeof(x507) / sizeof(coords),
    sizeof(x508) / sizeof(coords),
    sizeof(x509) / sizeof(coords),
    sizeof(x510) / sizeof(coords),
    sizeof(x511) / sizeof(coords),
    sizeof(x512) / sizeof(coords),
    sizeof(x513) / sizeof(coords),
    sizeof(x514) / sizeof(coords),
    sizeof(x515) / sizeof(coords),
    sizeof(x516) / sizeof(coords),
    sizeof(x517) / sizeof(coords),
    sizeof(x518) / sizeof(coords),
    sizeof(x519) / sizeof(coords),
    sizeof(x520) / sizeof(coords),
    sizeof(x521) / sizeof(coords),
    sizeof(x522) / sizeof(coords),
    sizeof(x523) / sizeof(coords),
    sizeof(x524) / sizeof(coords),
    sizeof(x525) / sizeof(coords),
    sizeof(x526) / sizeof(coords),

    sizeof(x601) / sizeof(coords),
    sizeof(x602) / sizeof(coords),
    sizeof(x603) / sizeof(coords),
    sizeof(x604) / sizeof(coords),
    sizeof(x605) / sizeof(coords),
    sizeof(x606) / sizeof(coords),
    sizeof(x607) / sizeof(coords),
    sizeof(x608) / sizeof(coords),
    sizeof(x609) / sizeof(coords),
    sizeof(x610) / sizeof(coords),
    sizeof(x611) / sizeof(coords),
    sizeof(x612) / sizeof(coords),
    sizeof(x613) / sizeof(coords),
    sizeof(x614) / sizeof(coords),
    sizeof(x615) / sizeof(coords),
    sizeof(x616) / sizeof(coords),
    sizeof(x617) / sizeof(coords),
    sizeof(x618) / sizeof(coords),
    sizeof(x619) / sizeof(coords),
    sizeof(x620) / sizeof(coords),
    sizeof(x621) / sizeof(coords),
    sizeof(x622) / sizeof(coords),
    sizeof(x623) / sizeof(coords),
    sizeof(x624) / sizeof(coords),
    sizeof(x625) / sizeof(coords),
    sizeof(x626) / sizeof(coords)
};
