// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: ring.h,v 3.5 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_RING_H

class Ring;

#else	// XSC_RING_H
#define	XSC_RING_H

#include "laser.h"
#include "stats.h"
#include "tthing.h"

typedef enum _hitstatus {
    RING_DULL,
    RING_BRIGHT,
    RING_DEAD
} hitstatus;


class Ring : public Tthing {
private:
    hitstatus *hits;
    int numsegments;
    unsigned int value;
    GC *gcs;

    int which_seg(const float) const;

public:
    Ring(const float, const float, const unsigned int,
	    const GC *const, const int);
    ~Ring(void);

    void render(const bool);

    void seg_center(const float, float *const, float *const) const;
    bool hit(Laser *, Stats *);
    int remaining(void) const;
    bool hole(const float) const;
    void refresh(void);

    unsigned int get_value(void) const;
    void set_value(const unsigned int);
    void set_gc(const int, const GC);
};


inline unsigned int
Ring::get_value(void) const
{
    return value;
} // Ring::get_value


inline void
Ring::set_value(const unsigned int v)
{
    value = v;
} // Ring::set_value


inline void
Ring::set_gc(const int i, const GC ngc)
{
    gcs[i] = ngc;
} // Ring::set_gc

#endif	// XSC_RING_H
