// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: random.h,v 3.4 2005/01/02 19:11:17 mark Exp $

#ifndef	XSC_RANDOM_H
#define	XSC_RANDOM_H

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif	// HAVE_CONFIG_H

namespace Random {
    int get(void);
    void seed(unsigned int);
} // namespace Random


#if	HAVE_RANDOM && HAVE_SRANDOM

inline int
Random::get(void)
{
    return random();
} // Random::get


inline void
Random::seed(unsigned int x)
{
    srandom(x);
} // Random::seed

#else	// HAVE_RANDOM && HAVE_SRANDOM

inline int
Random::get(void)
{
    return rand();
} // Random::get


inline void
Random::seed(unsigned int x)
{
    srand(x);
} // Random::seed

#endif	// HAVE_RANDOM && HAVE_SRANDOM

#endif	// XSC_RANDOM_H
