// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: laser.h,v 3.5 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_LASER_H

class Laser;

#else	// XSC_LASER_H
#define	XSC_LASER_H

#include "castle.h"
#include "king.h"
#include "minefield.h"
#include "ship.h"
#include "stats.h"
#include "xything.h"

class Laser : public virtual Xything {
private:
    float age;
    float lifespan;
    float mag;

    void snuff(void);

    Ship *ship;

public:
    Laser(void);
    ~Laser(void);

    void render(const bool);

    void move(Castle *, King *, Minefield *, Stats *);
    void launch(void);
    void resize(const int, const int);

    bool alive(void) const;

    void set_ship(Ship *);
};


inline void
Laser::snuff(void)
{
    age = lifespan;
} // Laser::snuff


inline bool
Laser::alive(void) const
{
    return (age < lifespan);
} // Laser::alive


inline void
Laser::set_ship(Ship *s)
{
    ship = s;
} // Laser::set_ship

#endif	// XSC_LASER_H
