// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: global.h,v 3.7 2005/01/02 19:11:17 mark Exp $

#ifndef	XSC_GLOBAL_H
#define	XSC_GLOBAL_H

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif	// HAVE_CONFIG_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

/* gross, but this seems to work the best for now */
#include <stdio.h>
#include <cstdio>

#include <stddef.h>
#include <cstddef>

#include <cstdlib>
#include <stdlib.h>

#include <math.h>
#include <cmath>

#include <limits.h>
#include <climits>

#ifdef	DEBUG
#undef	NDEBUG
#include <assert.h>
#include <cassert>
#endif	// DEBUG


#ifndef	NULL
#define	NULL	0
#endif	/* NULL */

struct coords {
    float x;
    float y;
};

enum key_state {
    KEY_UP,
    KEY_DOWN
};


inline int
within(const float a, const float b, const float c)
{
    return (a >= (b - c) && a <= (b + c));
} // ::within


inline int
sign(const float a)
{
    return (a > 0.0) ? +1 : -1;
} // ::sign


inline float
max(const float a, const float b)
{
    return (a > b) ? a : b;
} // ::max


inline float
min(const float a, const float b)
{
    return (a < b) ? a : b;
} // ::min


inline float
sq(const float x)
{
    return x * x;
} // ::sq

#endif	// XSC_GLOBAL_H
