// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: castle.h,v 3.9 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_CASTLE_H

class Castle;

#else	// XSC_CASTLE_H
#define	XSC_CASTLE_H

#include "laser.h"
#include "minefield.h"
#include "ring.h"
#include "stats.h"

enum castle_rings {
    CASTLE_RING_OUTER,
    CASTLE_RING_MIDDLE,
    CASTLE_RING_INNER,
};

class Castle {
private:
    enum castle_states {
	CASTLE_STATE_NORMAL,
	CASTLE_STATE_REGENERATING,
	CASTLE_STATE_COLLAPSING,
	CASTLE_STATE_EXPLODING,
	CASTLE_STATE_RESTING
    };

    int numrings;
    Ring **rings;
    enum castle_states state;
    Stamp time_of_death;
    Stamp pause_start;
    Stamp pause_sum;

public:
    Castle(void);
    ~Castle(void);

    void render(const bool);
    void draw(void);
    void erase(void);

    void turn(Minefield *, King *);
    void resize(const int, const int);
    bool collision(Laser *, Stats *);
    bool opening(const float) const;
    bool hole(const int, const float) const;
    float ring_size(const int) const;
    void seg_center(const int, /*const*/ float,
	    float * /*const*/, float * /*const*/);
    void explode(Stats *);
    GC get_gc(const int) const;
    void refresh(void) const;

    int get_numrings(void) const;
    void pause(const bool);
    bool alive() const;
};


inline void
Castle::draw(void)
{
    render(true);
} // Castle::draw


inline void
Castle::erase(void)
{
    render(false);
} // Castle::erase


inline int
Castle::get_numrings(void) const
{
    return numrings;
} // Castle::get_numrings


inline void
Castle::pause(const bool pause_state)
{
    if (pause_state) {
	pause_start = time_now;
    } else {
	pause_sum += time_now - pause_start;
    }
} // Castle::pause


inline bool
Castle::alive(void) const
{
    return (state != CASTLE_STATE_EXPLODING && state != CASTLE_STATE_RESTING);
} // Castle::alive

#endif	// XSC_CASTLE_H
