/*

    xpuyopuyo - pwindow-gtk.h       Copyright(c) 1999 Havoc Pennington
    hp@pobox.com

    Header for window (user interface) for GTK/GNOME


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __pwindow_gtk_h_included
#define __pwindow_gtk_h_included


#include <xpuyopuyo.h>
#include <pwindow.h>


#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#define P_GTK_STRING_BUFFER         0x1000                           /* Size of any string buffer in the GTK functions */
#define P_GTK_TOOLTIP_DELAY         1000


/* Keystroke definitions */
#define P_NUM_ALTERNATE_KEYS        3                                /* Total number of keys to support for each function */
#define P_NUM_KEY_TYPES             4                                /* Left, Right, Up, Down for each player */
#define P_NUM_KEYS_PER_PLAYER       (P_NUM_ALTERNATE_KEYS * P_NUM_KEY_TYPES)  /* Number of key defs per player */
#define P_NUM_KEYS                  (P_NUM_KEYS_PER_PLAYER * P_NUM_PLAYERS)   /* Total number of defined keys */
#define P_KEY_INDEX(p, t, a)        ((p) * P_NUM_KEYS_PER_PLAYER + (t) * P_NUM_ALTERNATE_KEYS + (a))
#define P_KEY(k, p, t, a)           ((k).keys[P_KEY_INDEX((p), (t), (a))])    /* Lookup a key value */
#define P_KEYW(w, p, t, a)          P_KEY((w)->pkey, (p), (t), (a))
#define P_KEY_I(k, i)               ((k).keys[(i)])  
#define P_KEY_IW(w, i)              P_KEY_I((w)->pkey, (i))

#define P_KEY_GET_PLAYER(idx)       ((idx) / P_NUM_KEYS_PER_PLAYER)                    /* Which player for this index? */
#define P_KEY_GET_KEY_TYPE(idx)     (((idx) / P_NUM_ALTERNATE_KEYS) % P_NUM_KEY_TYPES) /* Which key type for this index? */
#define P_KEY_GET_ALTERNATE(idx)    ((idx) % P_NUM_ALTERNATE_KEYS)                     /* Which alternate code? */

#define P_KEY_LEFT                  0     /* Left keystroke */
#define P_KEY_RIGHT                 1     /* Right keystroke */
#define P_KEY_UP                    2     /* Up keysstroke   */
#define P_KEY_DOWN                  3     /* Down keystroke */


typedef struct _pwindow_key_gtk {
   guint keys[P_NUM_KEYS];
} pwindow_key_gtk;
   

/* Image tiles */
#define P_IMAGE_ROCK(i)             (0 + (i))   /* P_NUM_ROCKS number of these images */
#define P_IMAGE_ROCK_NORMAL         P_IMAGE_ROCK(0)
#define P_IMAGE_ROCK_BIG            P_IMAGE_ROCK(1)
#define P_IMAGE_ROCK_DEMON          P_IMAGE_ROCK(2)
#define P_IMAGE_ROCK_IND            P_IMAGE_ROCK(3)
#define P_IMAGE_LAST_ROCK           P_IMAGE_ROCK(P_NUM_ROCKS)
#define P_IMAGE_UNJOINED(i)         (P_IMAGE_LAST_ROCK + (i)) /* P_NUMCOLORS of these */
#define P_IMAGE_LAST_UNJOINED       P_IMAGE_UNJOINED(P_COLORS_MAX)
#define P_IMAGE_JOINED(i)           (P_IMAGE_LAST_UNJOINED + (i)) /* P_NUMCOLORS of these */
#define P_IMAGE_LAST_JOINED         P_IMAGE_JOINED(P_COLORS_MAX)
#define P_IMAGE_CLEAR_BLUE          (P_IMAGE_LAST_JOINED + 0)
#define P_IMAGE_CLEAR_RED           (P_IMAGE_LAST_JOINED + 1)
#define P_IMAGE_EXPLOSION           (P_IMAGE_LAST_JOINED + 2)
#define P_IMAGE_STAR                P_IMAGE_EXPLOSION
#define P_IMAGE_BORDER_TOP          (P_IMAGE_LAST_JOINED + 3)
#define P_IMAGE_BORDER_TOPLEFT      (P_IMAGE_LAST_JOINED + 4)
#define P_IMAGE_BORDER_TOPRIGHT     (P_IMAGE_LAST_JOINED + 5)
#define P_IMAGE_BORDER_LEFT         (P_IMAGE_LAST_JOINED + 6)
#define P_IMAGE_BORDER_RIGHT        (P_IMAGE_LAST_JOINED + 7)
#define P_IMAGE_BORDER_BOTTOMLEFT   (P_IMAGE_LAST_JOINED + 8)
#define P_IMAGE_BORDER_BOTTOMRIGHT  (P_IMAGE_LAST_JOINED + 9)
#define P_IMAGE_BORDER_BOTTOM(i)    (P_IMAGE_LAST_JOINED + 10 + (i)) /* P_NUM_BOTTOM_TILES of these */
#define P_IMAGE_LAST_BORDER_BOTTOM  P_IMAGE_BORDER_BOTTOM(P_NUM_BOTTOM_TILES)
#define P_IMAGE_GAME_TITLE          (P_IMAGE_LAST_BORDER_BOTTOM + 0)
#define P_IMAGE_GAME_OVER           (P_IMAGE_LAST_BORDER_BOTTOM + 1)
#define P_IMAGE_PAUSED              (P_IMAGE_LAST_BORDER_BOTTOM + 2)
#define P_IMAGE_NUMBER(i)           (P_IMAGE_LAST_BORDER_BOTTOM + 3 + (i)) /* 10 of these */
#define P_IMAGE_LAST_NUMBER         P_IMAGE_NUMBER(10)
#define P_NUM_IMAGES                P_IMAGE_LAST_NUMBER

#define P_IMAGE(img, i)             ((img).tiles[(i)])
#define P_IMAGE_MASK(img, i)        ((img).masks[(i)])
#define P_IMAGEW(w, i)              P_IMAGE((w)->img, (i))
#define P_IMAGE_MASKW(w, i)         P_IMAGE_MASK((w)->img, (i))


/* Images available for the window */
typedef struct _pwindow_img_gtk {
   GdkPixmap *tiles[P_NUM_IMAGES];
   GdkBitmap *masks[P_NUM_IMAGES];
} pwindow_img_gtk;


/* Menu constants */
#define P_MENU_MAIN                 0
#define P_MENU_GAME_START           1
#define P_MENU_GAME_RESTART         2
#define P_MENU_GAME_PAUSE           3
#define P_MENU_GAME_END             4
#define P_MENU_OPTIONS_SINGLE_PLAYER 6
#define P_MENU_OPTIONS_HUMAN_HUMAN  7
#define P_MENU_OPTIONS_HUMAN_AI     8
#define P_MENU_OPTIONS_AI_AI        9
#define P_MENU_OPTIONS_NETWORK      10
#define P_MENU_OPTIONS_NETWORK_AI   11
#define P_MENU_OPTIONS_TUTORIAL     12
#define P_MENU_OPTIONS_SET_KEYS     13
#define P_MENU_OPTIONS_SET_OPTIONS  14
#define P_MENU_OPTIONS              P_MENU_OPTIONS_SET_OPTIONS
#define P_MENU_AI_RULE_0            15
#define P_MENU_AI_RULE_1            16
#define P_MENU_OPTION_EASY          17
#define P_MENU_OPTION_MEDIUM        18
#define P_MENU_OPTION_HARD          19
#define P_MENU_GAME_HIGH_SCORES     20
#define P_MENU_NET_SERVER           21
#define P_MENU_NET_CLIENT           22
#define P_MENU_NET_TERMINATE        23
#define P_NUM_MENUS                 24

#define P_MENU(menu, i)             ((menu).menus[(i)])
#define P_MENUW(w, i)               P_MENU((w)->menu, (i))


typedef struct _pwindow_menu_gtk {
   GtkWidget *menus[P_NUM_MENUS];
} pwindow_menu_gtk;


typedef struct _pwindow_gtk_status {
   GtkWidget *frame; /* Frame containing status widget */
   GtkWidget *da;    /* Drawable area for status widget */
   GdkPixmap *buffer;/* Buffer containing text image */
   char *message;    /* Message to display */
} pwindow_gtk_status;


typedef struct _pwindow_gtk {
   GtkWidget *app;   /* main window */
   GtkWidget *da;    /* drawing area for playing field */
   GdkPixmap *buffer;/* offscreen drawable for field */

   pwindow_gtk_status player[2];/* Player information (both players) */
   pwindow_gtk_status status; /* Status bar in main window */

   pwindow_img_gtk img;  /* Images for game */
   pwindow_menu_gtk menu;/* Menus for GTK Interface */
   pwindow_key_gtk pkey; /* Keys for each player */

   gboolean exposed; /* Set to true after first expose event */
   gboolean ready;   /* Set to true when images loaded */
   pconfig *c;       /* Pointer to config structure */
   
   GtkTooltips *tooltips;  /* Tooltips control */
} pwindow_gtk;


gint pixmap_width(GdkPixmap* p);
gint pixmap_height(GdkPixmap* p);
void p_window_put_subimage(const pwindow_gtk *w, GdkPixmap* pix, GdkBitmap* mask, int sx, int sy, int dx, int dy, int w_, int h_);
void p_window_put_image(const pwindow_gtk *w, GdkPixmap *pix, GdkBitmap* mask, int dx, int dy);
void p_window_put_subimage_index(const pwindow_gtk *w, int imageindex, int sx, int sy, int dx, int dy, int w_, int h_);
void p_window_put_image_index(const pwindow_gtk *w, int imageindex, int dx, int dy);
void p_window_statusbar_paint(pwindow_gtk_status *s);
            

#endif

