/*

    xpuyopuyo - pnet-gtk.c          Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org           http://chaos2.org/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <xpuyopuyo.h>
#if USE_NETWORK


#include <config.h>
#include <pnet-gtk.h>
#include <pdialog-gtk.h>
#include <pnet.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <psnprintf.h>



void p_network_server(pwindow_gtk *w) {

   int value;
   
   value = P_NET_DEFAULT_PORT;
   if(p_dialog_query_value(w, "Create Server", "Enter port number to listen to:", &value)) {
      /* Dialogue was not cancelled */
      if(value <= 0 || value > 65535) {
         p_dialog_error(w, "Invalid port specified.");
      } else {
         pnet_close(w->c, &w->c->socket);
         w->c->socket = pnet_new_server(w->c, value);
         if(w->c->socket == NULL) {
            p_dialog_error(w, "Unable to establish a server");
         }
      }
   } /* Did we get a value from the user? */
   
   return;

}



static void p_network_server_changed(GtkWidget *widget, gpointer data) {

   char *server = data;
   p_strncpy(server, gtk_entry_get_text(GTK_ENTRY(widget)), P_GTK_STRING_BUFFER);
   return;

}

         

static void p_network_port_changed(GtkWidget *widget, gpointer data) {

   char *port = data;
   p_strncpy(port, gtk_entry_get_text(GTK_ENTRY(widget)), P_GTK_STRING_BUFFER);
   return;

}
         

void p_network_client(pwindow_gtk *w) {

   p_dialog_window dw;
   char server[P_GTK_STRING_BUFFER];
   char port[P_GTK_STRING_BUFFER];
   GtkWidget *server_entry;
   GtkWidget *port_entry;
   GtkWidget *grid;
   GtkWidget *msg;
   char *p;
   int pnum;

   p_dialog_window_new(&dw, w, "Connect To Server", "Select the name of server and the port to connect to:", P_DIALOG_QUERY);

   grid = gtk_table_new(2, 2, FALSE);
   gtk_box_pack_start(GTK_BOX(dw.container), grid, TRUE, TRUE, 0);

   msg = gtk_label_new("Server name:  ");
   gtk_table_attach(GTK_TABLE(grid), msg, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 2, 2);
   server_entry = gtk_entry_new();
   p_strncpy(server, "localhost", P_GTK_STRING_BUFFER);
   gtk_entry_set_text(GTK_ENTRY(server_entry), server);
   gtk_signal_connect(GTK_OBJECT(server_entry), "changed", GTK_SIGNAL_FUNC(p_network_server_changed), server);
   gtk_table_attach(GTK_TABLE(grid), server_entry, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);

   msg = gtk_label_new("Port number:  ");
   gtk_table_attach(GTK_TABLE(grid), msg, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 2, 2);
   port_entry = gtk_entry_new();
   p_snprintf(port, P_GTK_STRING_BUFFER, "%d", P_NET_DEFAULT_PORT);
   gtk_entry_set_text(GTK_ENTRY(port_entry), port);
   gtk_signal_connect(GTK_OBJECT(port_entry), "changed", GTK_SIGNAL_FUNC(p_network_port_changed), port);
   gtk_table_attach(GTK_TABLE(grid), port_entry, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 2, 2);

   if(p_dialog_window_run(&dw)) {
      pnum = strtol(port, &p, 0);
      if(*p || pnum <= 0 || pnum > 65535) {
         p_dialog_error(w, "Invalid port specified.");
      } else {
         pnet_close(w->c, &w->c->socket);
         w->c->socket = pnet_new_client(w->c, server, pnum);
         if(w->c->socket == NULL) {
            p_dialog_error(w, "Unable to establish a connection to the server");
         }
      }     
   }

   return;

}


#endif /* NO_NETWORK? */
