#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include "mysystem.h"
#include "appres.h"

extern char *malloc();
extern char *getenv();

extern int	errno;
extern Argc;
extern char **Argv;
extern AppResources app_resources;

#ifdef NOPUTENV
static char **newenv, *value;

static int putenv(entry)
char * entry;
{
    int ep;

    extern char **environ;

    for (ep = 0;  environ[ep];  ++ep) {}

    if ( !(newenv = (char **) malloc((unsigned) (sizeof(char*) * (ep + 2)))) )
    {
	return 1;
    }
    
    for (ep = 0;  environ[ep];  ++ep)
    {
	newenv[ep] = environ[ep];
    }

    if ( !(value = malloc((unsigned) (strlen(entry) + 1))) )
    {
	free(newenv);
	return 1;
    }

    strcpy(value, entry);
    newenv[ep] = value;
    newenv[++ep] = 0;
    environ = newenv;

    return 0;
}
#endif

/*
 * mysystem
 *
 * execute a shell command, setting postitional args to the filenames
 * and $i to current file - use $SHELL for shell & default to /bin/sh
 * 
 *
 */

mysystem(cmnd,currentfile)
    char *cmnd;
    char *currentfile;
{
    int	pid;    /* process ID of child */
    int	died;
    int	status; /* exit status of the command */
    SIGNAL_T (*istat)(), (*qstat)();

    char	   *fusershell = 0;
    char	   *usershell;

    char *buf;
    static char **argv;
    int i;

   
    if (app_resources.useMyShell) {
	fusershell = getenv("SHELL"); 
	if (!fusershell) fusershell = getenv("shell");
    }
    if (!fusershell) fusershell = "/bin/sh";
    usershell = strrchr(fusershell, '/');
    if (usershell)
	usershell++;
    else
	usershell = fusershell;


    pid = fork();
    switch (pid) {
    case -1:	    /* error */
	status = -1;
	break;

    case 0:	/* child */

/* here we stick i=currentfile into the environment */
	buf = malloc(strlen(currentfile)+strlen(cmnd) + 4);
	sprintf(buf,"%s=%s","i",currentfile);
	putenv(buf); 

/* now we add the postitional args for "sh -c" i.e set them
 * to the file names - and allow for silly sh being 1 position out
 */
        argv = (char **)malloc((Argc+4) * sizeof(*Argv));
	argv[0] = usershell;
	argv[1] = "-c";
	argv[2] = cmnd;
        
        if (strcmp(usershell,"sh") == 0) {
	    argv[3] = usershell;
	    for (i = 1; i < Argc; i++)
		argv[i+3] = Argv[i];
	    i++;
	} else {
            for (i = 1; i < Argc; i++)
	        argv[i+2] = Argv[i];
	}

	argv[i+2] = 0;
	execv(fusershell, argv);
	_exit(127);    /* if we get here, the exec failed */

    default:	    /* parent */
        istat = signal(SIGINT, SIG_IGN);
        qstat = signal(SIGQUIT, SIG_IGN);
	do {
	    died = wait(&status);
	} while (died >= 0 && died != pid);
	if (died < 0) {
	    status = -1;
	}
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);

    }
    return status;
}


static int pid;

/*
 * mypopen
 * return FILE to user's shell command for writing, NULL for failure
 *
 * nb stores pid of child for future mypclose so must not be called
 * again before a mypclose
 */


FILE *
mypopen(cmnd,currentfile)
    char *cmnd;
    char *currentfile;
{

    int pipes[2];
    int	died;

    char	   *fusershell = 0;
    char	   *usershell;

    char *buf;
    static char **argv;
    int i;

    if (app_resources.useMyShell) {
	fusershell = getenv("SHELL"); 
	if (!fusershell) fusershell = getenv("shell");
    }
    if (!fusershell) fusershell = "/bin/sh";

    usershell = strrchr(fusershell, '/');
    if (usershell)
	usershell++;
    else
	usershell = fusershell;

    if (pipe(pipes) < 0)
	return (NULL);

    pid = fork();

    switch (pid) {
    case -1:	    /* error */
	return (NULL);
	break;

    case 0:	/* child */

/* here we stick i=currentfile into the environment */
	buf = malloc(strlen(currentfile)+strlen(cmnd) + 4);
	sprintf(buf,"%s=%s","i",currentfile);
	putenv(buf); 

	close(pipes[1]);
        if (pipes[0] != 0) {
	    dup2(pipes[0],0);
	    close(pipes[0]);
     	}
	execl(fusershell, usershell, "-c", cmnd, (char *)0);
	_exit(127);    /* if we get here, the exec failed */

    default:	    /* parent */
	close(pipes[0]);
	return (fdopen(pipes[1], "w"));

    }
}       

/*
 * mypclose
 *
 * close pipe & wait for pid spawned by popen
 *
 */

int
mypclose(fp)
FILE *fp;
{
    int	died;
    int	status; /* exit status of the command */

    fclose(fp);

    do {
	  died = wait(&status);
    } while (died >= 0 && died != pid);
    if (died < 0) {
	status = -1;
    }

   return (status);
}
