/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern Display *display;
extern Window win;
extern GC gc;
extern Pixmap theMask;
extern void error(int errorCode);
extern XpmAttributes myXpmAttributes;

sideBar::sideBar() {
  allWalls = new newWalls;
  dispX = new numericDisplay(2, 0, 5, 501);
  dispY = new numericDisplay(2, 0, 5, 528);
  keepGoing = 1;
  saveMe = 0;
  loadMe = 0;
  newMe = 0;
  mouseX = 0;
  mouseY = 0;
  mouseDown = 0;
  type = 'b';
}

void sideBar::draw() {
  char i;

  for (i = 'b'; i < 't'; i++) {
    XClearArea(display, win, 2, (i - 'b') * 26 + 1, 26, 26, False);
    allWalls->draw(i, 4, (i - 'b') * 26 + 3, 22, 22);
    if (i == type) {
      XSetClipOrigin(display, gc, 2, (i - 'b') * 26 + 1);
      XSetClipMask(display, gc, theMask);
      allWalls->draw('x', 2, (i - 'b') * 26 + 1, 26, 26);
      XSetClipMask(display, gc, None);
    }
  }
  allWalls->draw('t', 1, 585, 29, 11);
  allWalls->draw('u', 1, 605, 29, 11);
  allWalls->draw('v', 1, 625, 29, 11);
  allWalls->draw('w', 1, 645, 29, 11);
  dispX->draw();
  dispY->draw();
}

void sideBar::drawSome(char one, char two) {
  XClearArea(display, win, 2, (one - 'b') * 26 + 1, 26, 26, False);
  allWalls->draw(one, 4, (one - 'b') * 26 + 3, 22, 22);
  XSetClipOrigin(display, gc, 2, (two - 'b') * 26 + 1);
  XSetClipMask(display, gc, theMask);
  allWalls->draw('x', 2, (two - 'b') * 26 + 1, 26, 26);
  XSetClipMask(display, gc, None);
}

sideBar::~sideBar() {
  delete allWalls;
  delete dispX;
  delete dispY;
}

void sideBar::buttonPress(int x, int y) {
  mouseDown = 1;
  mouseX = x;
  mouseY = y;
}

void sideBar::buttonRelease(int x, int y) {
  if (mouseDown) {
    mouseDown = 0;
    if (mouseY <= 471 && y <= 471) {
      if (mouseX >= 4 && x >= 4 && mouseX <= 25 && x <= 25) {
        if ((mouseY-3) / 26 == (y-3) / 26) {
          if (((mouseY-3) % 26) < 22 && ((y-3) % 26) < 22) {
            type = (mouseY-3) / 26 + 'b';
            draw();
          }
        }
      }
    }
    else if (mouseY >= 585 && y <= 595) {
      newMe = 1;
    }
    else if (mouseY >= 605 && y <= 615) {
      loadMe = 1;
    }
    else if (mouseY >= 625 && y <= 635) {
      saveMe = 1;
    }
    else if (mouseY >= 645 && y <= 655) {
      keepGoing = 0;
    }
  }
}

int sideBar::go() {
  return keepGoing;
}

char sideBar::getType() {
  return type;
}

void sideBar::setType(char letter) {
  if (letter != 'a') {
    drawSome(type, letter);
    type = letter;
  }
}

int sideBar::shouldNew() {
  if (newMe == 1) {
    newMe = 0;
    return 1;
  }
  return 0;
}

int sideBar::shouldLoad() {
  if (loadMe == 1) {
    loadMe = 0;
    return 1;
  }
  return 0;
}

int sideBar::shouldSave() {
  if (saveMe == 1) {
    saveMe = 0;
    return 1;
  }
  return 0;
}

void sideBar::setDispXY(int newX, int newY) {
  if (newX >= 0 && newX < 92) {
    dispX->setValue(newX);
    dispX->draw();
  }
  if (newY >= 0 && newY < 66) {
    dispY->setValue(newY);
    dispY->draw();
  }
}
