/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern Window win;
extern GC gc;
extern Display *display;
extern void error(int errorCode);
extern XpmAttributes myXpmAttributes;
extern char* colors[];
extern Pixmap bonusXpms[NUMBONUS];
extern int stayOnLevel;

statusBar::statusBar(char theName[], int ax, int ay, int which) {
  int foo;

  x = ax;
  y = ay;
  makePixmap(num0_xpm, &numbers[0]);
  makePixmap(num1_xpm, &numbers[1]);
  makePixmap(num2_xpm, &numbers[2]);
  makePixmap(num3_xpm, &numbers[3]);
  makePixmap(num4_xpm, &numbers[4]);
  makePixmap(num5_xpm, &numbers[5]);
  makePixmap(num6_xpm, &numbers[6]);
  makePixmap(num7_xpm, &numbers[7]);
  makePixmap(num8_xpm, &numbers[8]);
  makePixmap(num9_xpm, &numbers[9]);
  makePixmap(unused_xpm, &numbers[10]);
  nameLength = strlen(theName);
  if (nameLength > MAXNAMELENGTH)
    nameLength = MAXNAMELENGTH;
  for (foo = 0; foo < nameLength; foo++) {
    theName[foo]=tolower(theName[foo]);
    switch (theName[foo]) {
      case 'a':
        strcpy (a_xpm[2],colors[6*which+2]);
        a_xpm[2][0]='a';
        strcpy (a_xpm[3],colors[6*which+5]);
        makePixmap(a_xpm, &letters[foo]);
        break;
      case 'b':
        strcpy (b_xpm[2],colors[6*which+2]);
        b_xpm[2][0]='a';
        strcpy (b_xpm[3],colors[6*which+5]);
        makePixmap(b_xpm, &letters[foo]);
        break;
      case 'c':
        strcpy (c_xpm[2],colors[6*which+2]);
        c_xpm[2][0]='a';
        strcpy (c_xpm[3],colors[6*which+5]);
        makePixmap(c_xpm, &letters[foo]);
        break;
      case 'd':
        strcpy (d_xpm[2],colors[6*which+2]);
        d_xpm[2][0]='a';
        strcpy (d_xpm[3],colors[6*which+5]);
        makePixmap(d_xpm, &letters[foo]);
        break;
      case 'e':
        strcpy (e_xpm[2],colors[6*which+2]);
        e_xpm[2][0]='a';
        strcpy (e_xpm[3],colors[6*which+5]);
        makePixmap(e_xpm, &letters[foo]);
        break;
      case 'f':
        strcpy (f_xpm[2],colors[6*which+2]);
        f_xpm[2][0]='a';
        strcpy (f_xpm[3],colors[6*which+5]);
        makePixmap(f_xpm, &letters[foo]);
        break;
      case 'g':
        strcpy (g_xpm[2],colors[6*which+2]);
        g_xpm[2][0]='a';
        strcpy (g_xpm[3],colors[6*which+5]);
        makePixmap(g_xpm, &letters[foo]);
        break;
      case 'h':
        strcpy (h_xpm[2],colors[6*which+2]);
        h_xpm[2][0]='a';
        strcpy (h_xpm[3],colors[6*which+5]);
        makePixmap(h_xpm, &letters[foo]);
        break;
      case 'i':
        strcpy (i_xpm[2],colors[6*which+2]);
        i_xpm[2][0]='a';
        strcpy (i_xpm[3],colors[6*which+5]);
        makePixmap(i_xpm, &letters[foo]);
        break;
      case 'j':
        strcpy (j_xpm[2],colors[6*which+2]);
        j_xpm[2][0]='a';
        strcpy (j_xpm[3],colors[6*which+5]);
        makePixmap(j_xpm, &letters[foo]);
        break;
      case 'k':
        strcpy (k_xpm[2],colors[6*which+2]);
        k_xpm[2][0]='a';
        strcpy (k_xpm[3],colors[6*which+5]);
        makePixmap(k_xpm, &letters[foo]);
        break;
      case 'l':
        strcpy (l_xpm[2],colors[6*which+2]);
        l_xpm[2][0]='a';
        strcpy (l_xpm[3],colors[6*which+5]);
        makePixmap(l_xpm, &letters[foo]);
        break;
      case 'm':
        strcpy (m_xpm[2],colors[6*which+2]);
        m_xpm[2][0]='a';
        strcpy (m_xpm[3],colors[6*which+5]);
        makePixmap(m_xpm, &letters[foo]);
        break;
      case 'n':
        strcpy (n_xpm[2],colors[6*which+2]);
        n_xpm[2][0]='a';
        strcpy (n_xpm[3],colors[6*which+5]);
        makePixmap(n_xpm, &letters[foo]);
        break;
      case 'o':
        strcpy (o_xpm[2],colors[6*which+2]);
        o_xpm[2][0]='a';
        strcpy (o_xpm[3],colors[6*which+5]);
        makePixmap(o_xpm, &letters[foo]);
        break;
      case 'p':
        strcpy (p_xpm[2],colors[6*which+2]);
        p_xpm[2][0]='a';
        strcpy (p_xpm[3],colors[6*which+5]);
        makePixmap(p_xpm, &letters[foo]);
        break;
      case 'q':
        strcpy (q_xpm[2],colors[6*which+2]);
        q_xpm[2][0]='a';
        strcpy (q_xpm[3],colors[6*which+5]);
        makePixmap(q_xpm, &letters[foo]);
        break;
      case 'r':
        strcpy (r_xpm[2],colors[6*which+2]);
        r_xpm[2][0]='a';
        strcpy (r_xpm[3],colors[6*which+5]);
        makePixmap(r_xpm, &letters[foo]);
        break;
      case 's':
        strcpy (s_xpm[2],colors[6*which+2]);
        s_xpm[2][0]='a';
        strcpy (s_xpm[3],colors[6*which+5]);
        makePixmap(s_xpm, &letters[foo]);
        break;
      case 't':
        strcpy (t_xpm[2],colors[6*which+2]);
        t_xpm[2][0]='a';
        strcpy (t_xpm[3],colors[6*which+5]);
        makePixmap(t_xpm, &letters[foo]);
        break;
      case 'u':
        strcpy (u_xpm[2],colors[6*which+2]);
        u_xpm[2][0]='a';
        strcpy (u_xpm[3],colors[6*which+5]);
        makePixmap(u_xpm, &letters[foo]);
        break;
      case 'v':
        strcpy (v_xpm[2],colors[6*which+2]);
        v_xpm[2][0]='a';
        strcpy (v_xpm[3],colors[6*which+5]);
        makePixmap(v_xpm, &letters[foo]);
        break;
      case 'w':
        strcpy (w_xpm[2],colors[6*which+2]);
        w_xpm[2][0]='a';
        strcpy (w_xpm[3],colors[6*which+5]);
        makePixmap(w_xpm, &letters[foo]);
        break;
      case 'x':
        strcpy (x_xpm[2],colors[6*which+2]);
        x_xpm[2][0]='a';
        strcpy (x_xpm[3],colors[6*which+5]);
        makePixmap(x_xpm, &letters[foo]);
        break;
      case 'y':
        strcpy (y_xpm[2],colors[6*which+2]);
        y_xpm[2][0]='a';
        strcpy (y_xpm[3],colors[6*which+5]);
        makePixmap(y_xpm, &letters[foo]);
        break;
      case 'z':
        strcpy (z_xpm[2],colors[6*which+2]);
        z_xpm[2][0]='a';
        strcpy (z_xpm[3],colors[6*which+5]);
        makePixmap(z_xpm, &letters[foo]);
        break;
    }
  }
}

statusBar::~statusBar() {
  int foo;
  
  for (foo = 0; foo < 11; foo++)
    XFreePixmap(display, numbers[foo]);
  for (foo = 0; foo < nameLength; foo++)
    XFreePixmap(display, letters[foo]);
}

void statusBar::update(int lives, int score, int which, int numCut) {
  int foo;
  int temp;
  char scores[9];
  int past = 0;

  if (which & 1) {
    temp = x;
    for (foo = 0; foo < nameLength; foo++) {
      XCopyArea(display, letters[foo], win, gc, 0, 0, 10, 20, temp, y);
      temp += 10;
    }
    temp += 10;
    if (lives >= 0)
      XCopyArea(display, numbers[lives], win, gc, 0, 0, 10, 20, temp, y);
    else
      XCopyArea(display, numbers[10], win, gc, 0, 0, 10, 20, temp, y);
    temp += 10;
  }
  if (which & 2) {
    temp = x + nameLength * 11 + 30;
    if (score) {
      sprintf(scores, "%09d", score);
      for (foo = 0; foo < 9; foo++) {
        if ((scores[foo] == '0') && (!past))
          XCopyArea(display, numbers[10], win, gc, 0, 0, 10, 20, temp, y); else {
          XCopyArea(display, numbers[scores[foo] - '0'], win, gc, 0, 0, 10, 20, temp, y);
          past = 1;
        }
        temp += 10;
      }
    } else {
      for (foo = 0; foo < 8; foo++) {
        XCopyArea(display, numbers[10], win, gc, 0, 0, 10, 20, temp, y);
        temp += 10;
      }
      XCopyArea(display, numbers[0], win, gc, 0, 0, 10, 20, temp, y);
      temp += 10;
    }
    temp += 10;
    if (numCut)
      XCopyArea(display, bonusXpms[6], win, gc, 0, 0, 20, 20, temp, y);
    else
      XClearArea(display, win, temp, y, 20, 20, False);
  }
}
