/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern char objects[BWIDTH][BHEIGHT];
extern people *thePlayers;
extern boni *theWarps;
extern int warpx, warpy;

levels::levels() {
  FILE *in;
  char names[256];

  if ((in = fopen(DATADIR"/levels/LEVELS", "r"))==NULL) {
    fprintf(stderr,"Unable to open "DATADIR"/levels/LEVELS database!\n");
    exit(1);
  }
  numLevels = 0;
  while (fgets(names, 255, in))
    numLevels++;
  fclose(in);
}

void levels::copyLevel(int which) {
  int foo, bar;
  int numWorm = 1;
  FILE *in;
  char fileName[255];
  char levelarr[BHEIGHT][BWIDTH];
  
  if ((in = fopen(DATADIR"/levels/LEVELS", "r"))==NULL) {
    fprintf(stderr,"Unable to open "DATADIR"/levels/LEVELS database!\n");
    exit(1);
  }
  for (foo = 0; foo < which; foo++) {
    fgets(fileName, 255, in);
  }
  fileName[strlen(fileName) - 1] = 0;
  fclose(in);
  if ((in = fopen(fileName, "r"))==NULL) {
    fprintf(stderr,"Unable to open level file %s!\n", fileName);
    exit(1);
  }
  for (foo = 0; foo < BHEIGHT; foo++) {
    fgets(levelarr[foo], 255, in);
    levelarr[foo][strlen(levelarr[foo])] = 0;
  }
  fclose(in);
  for (foo = 0; foo < BWIDTH; foo++)
    for (bar = 0; bar < BHEIGHT; bar++) {
      objects[foo][bar] = levelarr[bar][foo];
      if (objects[foo][bar] == 'm')
        thePlayers->setPosDir(numWorm++, foo, bar, 0, -1);
      if (objects[foo][bar] == 'n')
        thePlayers->setPosDir(numWorm++, foo, bar, -1, 0);
      if (objects[foo][bar] == 'o')
        thePlayers->setPosDir(numWorm++, foo, bar, 0, 1);
      if (objects[foo][bar] == 'p')
        thePlayers->setPosDir(numWorm++, foo, bar, 1, 0);
      if (objects[foo][bar] >= 'm' && objects[foo][bar] <= 'p')
        objects[foo][bar] = 'a';
      if (objects[foo][bar] == 'B' || objects[foo][bar] == 'C') {
        objects[foo - 1][bar] = objects[foo][bar];
        objects[foo - 1][bar - 1] = objects[foo][bar];
        objects[foo][bar - 1] = objects[foo][bar];
        theWarps->addBonus(objects[foo][bar], 1, foo - 1, bar - 1);
      }
      if (objects[foo][bar] == 'D') {
        warpx = foo;
        warpy = bar;
        objects[foo][bar] = 'a';
      }
    }
}

int levels::getNumLevels() {
  return numLevels;
}

levels::~levels() {
}
