/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern char objects[BWIDTH][BHEIGHT];
extern Display *display;
extern Window win;
extern GC gc;
extern Pixmap bonusXpms[3];

bonus::bonus(char letter1, char x1, char y1, int which2) {
  x = x1;
  y = y1;
  letter = letter1;
  which = which2;
  switch (letter1) {
    case 'A' : ske.set(266);
    break;
    case 'E' : ske.set(200);
    break;
    case 'F' : ske.set(133);
    break;
    case 'G' : ske.set(100);
    break;
    case 'H' : ske.set(200);
    break;
    case 'I' : ske.set(200);
    break;
    case 'J' : ske.set(400);
    break;
  }
}

bonus::~bonus() {
}

void bonus::erase() {
  XClearArea(display, win, x * 10, y * 10, 20, 20, False);
  objects[x][y] = 'a';
  objects[x + 1][y] = 'a';
  objects[x][y + 1] = 'a';
  objects[x + 1][y + 1] = 'a';
}

void bonus::draw() {
  objects[x][y] = letter;
  objects[x + 1][y] = letter;
  objects[x][y + 1] = letter;
  objects[x + 1][y + 1] = letter;
  XCopyArea(display, bonusXpms[which], win, gc, 0, 0, 20, 20, x * 10, y * 10);
}

int bonus::me(char x1, char y1) {
  if ((x1 == x && y1 == y) || (x1 == x + 1 && y1 == y) || (x1 == x && y1 == y + 1) || (x1 == x + 1 && y1 == y + 1))
    return 1;
  return 0;
}

int bonus::checkme() {
  if (ske.elapsed())
    return letter;
  return 0;
}
