/*-
 * Copyright (c) 1999 Thomas Runge (coto@core.de)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/XmAll.h>

#include "radio.h"
#include "misc.h"

static Boolean block;
static char *string;
static int yesno;

/* caller has to XtFree() the returned string! */
static void stringCB(Widget widget, XtPointer clientData,
                     XmFileSelectionBoxCallbackStruct *callData)
{
 if(!XmStringGetLtoR(callData->value, XmSTRING_DEFAULT_CHARSET, &string))
  string = NULL;

 block = False;
}

static void cancelCB(Widget widget, XtPointer clientData,
                                    XtPointer callData)
{
 string = NULL;
 block = False;
}

static void yesnoCB(Widget widget, XtPointer clientData,
                                   XtPointer callData)
{
 yesno = (int) clientData;
 block = False;
}

static void XtomWait(Widget widget)
{
 XtInputMask mask;
 XtAppContext app_con = XtWidgetToApplicationContext(widget);

 while(block)
 {
  while((mask = XtAppPending(app_con)) != 0)
  {
   XtAppProcessEvent(app_con, mask);
  }
 }

 XSync(XtDisplay(widget), 0);
 XmUpdateDisplay(widget);
}

char *XtomGetFileName(Widget parent, const char *title,
						const char *default_path, const char *filter,
						int width, int height)
{
 static Widget fsb=NULL;

 block = True;

 if(fsb==NULL)
 {
  Arg args[10];
  Cardinal n;

  n=0;
  XtSetArg(args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg(args[n], XmNautoUnmanage, True);                           n++;
  fsb = XmCreateFileSelectionDialog(parent, "fsbDialog", args, n);
  XtUnmanageChild(XmFileSelectionBoxGetChild(fsb, XmDIALOG_HELP_BUTTON));
                                    
  XtAddCallback(fsb, XmNokCallback, (XtCallbackProc)stringCB,
                                    (XtPointer)NULL);
  XtAddCallback(fsb, XmNcancelCallback, (XtCallbackProc)cancelCB,
                                    (XtPointer)NULL);
#ifdef HAS_XPM
  if(skin) 
   SkinToWidgets(fsb, skin);
#endif
 }

 if(default_path && strlen(default_path))
 {
  XmString xstr = XMSTR(default_path);
  XtVaSetValues(fsb, XmNdirectory, xstr, NULL);
  XmStringFree(xstr);
 }

 if(filter && strlen(filter))
 {
  XmString xstr = XMSTR(filter);
  XtVaSetValues(fsb, XmNpattern, xstr, NULL);
  XmStringFree(xstr);
 }

 if(width > 0 && height > 0)
 {
  XtVaSetValues(fsb, XmNwidth, width, XmNheight, height,
                XmNresizePolicy, XmRESIZE_NONE, NULL);
 }

 if(title && strlen(title))
 {
  Widget shell = XtParent(fsb);
  XtVaSetValues(shell, XmNtitle, title, NULL);
 }

 XtManageChild(fsb);
 
 XtomWait(parent);
 return(string);
}

Boolean XtomGetChoice(Widget parent, const char *title, const char *message)
{
 static Widget diaW;
 XmString xstr1, xstr2;
 Arg args[10];
 Cardinal n; 

 block = True;

 if(diaW == NULL)
 {
  n=0; 
  XtSetArg(args[n], XmNautoUnmanage, True);                    n++;
  XtSetArg(args[n], XmNdialogStyle,  XmDIALOG_FULL_APPLICATION_MODAL);
                                                               n++;
  XtSetArg(args[n], XmNmessageAlignment, XmALIGNMENT_CENTER);  n++;
  diaW = XmCreateQuestionDialog(parent, "question", args, n);
  XtUnmanageChild(XmMessageBoxGetChild(diaW, XmDIALOG_HELP_BUTTON));

  XtAddCallback(diaW, XmNokCallback, (XtCallbackProc)yesnoCB,
                                     (XtPointer)True);
  XtAddCallback(diaW, XmNcancelCallback, (XtCallbackProc)yesnoCB,
                                     (XtPointer)False);
#ifdef HAS_XPM
  if(skin) 
   SkinToWidgets(diaW, skin);
#endif
 }

 xstr1 = XMSTR(message);
 xstr2 = XMSTR(title);

 XtVaSetValues(diaW,
               XmNmessageString, xstr1,
               XmNdialogTitle,   xstr2,
               NULL);     
 XmStringFree(xstr1);
 XmStringFree(xstr2);
   
 XtManageChild(diaW);

 XtomWait(parent);
 return yesno;
}

void XtomShowMessage(Widget parent, unsigned char dialogType,
                     const char *title, const char *message)
{
 static Widget diaW;
 XmString xstr1, xstr2;
 Arg args[10];
 Cardinal n;

 block = True;

 if(diaW == NULL)
 {
  n=0; 
  XtSetArg(args[n], XmNautoUnmanage, True);                    n++;
  XtSetArg(args[n], XmNdialogStyle,  XmDIALOG_FULL_APPLICATION_MODAL);
                                                               n++;
  XtSetArg(args[n], XmNmessageAlignment, XmALIGNMENT_CENTER);  n++;
  diaW = XmCreateMessageDialog(parent, "message", args, n);
  XtUnmanageChild(XmMessageBoxGetChild(diaW, XmDIALOG_HELP_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(diaW, XmDIALOG_CANCEL_BUTTON));

  XtAddCallback(diaW, XmNokCallback, (XtCallbackProc)cancelCB,
                                                     (XtPointer)NULL);
  XtAddCallback(diaW, XmNcancelCallback, (XtCallbackProc)cancelCB,
                                                     (XtPointer)NULL);
#ifdef HAS_XPM
  if(skin) 
   SkinToWidgets(diaW, skin);
#endif
 }

 xstr1 = XMSTR(message);
 xstr2 = XMSTR(title);

 XtVaSetValues(diaW,
               XmNmessageString, xstr1,
               XmNdialogTitle,   xstr2,
               XmNdialogType,    dialogType,
               NULL);     
 XmStringFree(xstr1);
 XmStringFree(xstr2);

 XtManageChild(diaW);

 XtomWait(parent);
 return;
}

XmString XMSTR(const char *str)
{
 char *tmp = strdup(str);
 XmString xmstr = XmStringCreateLtoR(tmp, XmSTRING_DEFAULT_CHARSET);

 free(tmp);
 return(xmstr);
}


