/*
 * XML Catalog Manager (xmlcatmgr)
 * $Id: linklist.h,v 1.1 2004/08/31 19:07:23 jmmv Exp $
 *
 * Copyright (c) 2003, 2004 Julio M. Merino Vidal.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the author nor the names of contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef XMLCATMGR_LINKLIST_H
#define XMLCATMGR_LINKLIST_H

#define LINKLIST_ENTRY(type) \
    struct { \
        struct type *ole_next; \
        struct type *ole_prev; \
    } ole_entries

#define LINKLIST_HEAD(name, type) \
    struct name { \
        struct type *olh_first; \
        struct type *olh_last; \
    }

#define LINKLIST_INIT(head) { \
    (head)->olh_first = NULL; \
    (head)->olh_last = NULL; \
}

#define LINKLIST_APPEND(head, element) { \
    (element)->ole_entries.ole_next = NULL; \
    (element)->ole_entries.ole_prev = (head)->olh_last; \
    if ((head)->olh_first == NULL) \
        (head)->olh_first = (element); \
    if ((head)->olh_last != NULL) \
        (head)->olh_last->ole_entries.ole_next = (element); \
    (head)->olh_last = (element); \
}

#define LINKLIST_PREPEND(head, element) { \
    (element)->ole_entries.ole_next = (head)->olh_first; \
    (element)->ole_entries.ole_prev = NULL; \
    if ((head)->olh_last == NULL) \
        (head)->olh_last = (element); \
    if ((head)->olh_first != NULL) \
        (head)->olh_first->ole_entries.ole_prev = (element); \
    (head)->olh_first = (element); \
}

#define LINKLIST_REMOVE(head, element) { \
    if (((element)->ole_entries.ole_prev) != NULL) \
        (element)->ole_entries.ole_prev->ole_entries.ole_next = \
            (element)->ole_entries.ole_next; \
    else \
        (head)->olh_first = (element)->ole_entries.ole_next; \
    if (((element)->ole_entries.ole_next) != NULL) \
        (element)->ole_entries.ole_next->ole_entries.ole_prev = \
            (element)->ole_entries.ole_prev; \
    else \
        (head)->olh_last = (element)->ole_entries.ole_prev; \
    (element)->ole_entries.ole_prev = (element)->ole_entries.ole_next; \
}

#define LINKLIST_FOREACH(element, head) \
    for (element = (head)->olh_first; element != NULL; \
         element = (element)->ole_entries.ole_next)

#define LINKLIST_FIRST(head) (head)->olh_first
#define LINKLIST_NEXT(element) (element)->ole_entries.ole_next

#define LINKLIST_EMPTY(head) ((head)->olh_last == NULL)

#endif /* XMLCATMGR_LINKLIST_H */

/*
 * Local Variables: ***
 * mode: c ***
 * c-file-style: "stroustrup" ***
 * End: ***
 * vim: syntax=c:expandtab:shiftwidth=4:softtabstop=4
 */
