/*----------------------------------------------------------------------------
--
--  Module:           xitSetPos
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Attaches a widget to a relative position within a form.
--
--  Filename:         xitSetPos.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitSetPos.c, Version: 1.1, Date: 95/02/18 15:10:48";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void 
  xitSetPositional( Widget widget, 
                    int    top, 
                    int    left, 
                    int    right, 
                    int    bottom )
{

  /* Variables. */
  int  n;
  Arg  args[ 10 ];


  /* Code. */

  n = 0;

  if( top > 0 ) {
    XtSetArg( args[ n ], XmNtopAttachment,     XmATTACH_POSITION ); n++;
    XtSetArg( args[ n ], XmNtopPosition,       top ); n++;
  }

  if( left > 0 ) {
    XtSetArg( args[ n ], XmNleftAttachment,    XmATTACH_POSITION ); n++;
    XtSetArg( args[ n ], XmNleftPosition,      left ); n++;
  }

  if( right > 0 ) {
    XtSetArg( args[ n ], XmNrightAttachment,   XmATTACH_POSITION ); n++;
    XtSetArg( args[ n ], XmNrightPosition,     right ); n++;
  }

  if( bottom > 0 ) { 
    XtSetArg( args[ n ], XmNbottomAttachment,  XmATTACH_POSITION ); n++;
    XtSetArg( args[ n ], XmNbottomPosition,    bottom ); n++;
  }

  XtSetValues( widget, args, n );

} /* xitSetPositional */
