/*----------------------------------------------------------------------------
--
--  Module:           xitSetGeo
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Reads geometry specifications from a string and convert it into
--    x, y, height and width resources.
--
--  Filename:         xitSetGeo.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitSetGeo.c, Version: 1.1, Date: 95/02/18 15:10:48";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>

#include "Standard.h"

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xitSetGeometryResources( Screen    *screen,
                           char      *geometry_str,
                           Arg       args[],
                           Cardinal  *n )
{

  /* Variables. */
  int           flags;
  int           x;
  int           y;
  unsigned int  height;
  unsigned int  width;


  /* Code. */

  /* Format widthxheight+x+y? */
  flags = XParseGeometry( geometry_str, &x, &y, &width, &height );

  if( flagIsSet( flags, XNegative ) )
    x = WidthOfScreen( screen ) - x;

  if( flagIsSet( flags, YNegative ) )
    y = HeightOfScreen( screen ) - y;

  if( flagIsSet( flags, XValue ) ) {
    XtSetArg( args[ *n ], XmNx, x ); (*n)++;
  }

  if( flagIsSet( flags, YValue ) ) {
    XtSetArg( args[ *n ], XmNy, y ); (*n)++;
  }

  if( flagIsSet( flags, WidthValue ) ) {
    XtSetArg( args[ *n ], XmNwidth, width ); (*n)++;
  }

  if( flagIsSet( flags, HeightValue ) ) {
    XtSetArg( args[ *n ], XmNheight, height ); (*n)++;
  }


  return;

} /* xtmToSetGeometryResources */
