/*----------------------------------------------------------------------------
--
--  Module:           xitRwPixB
--
--  Project:          xitRw - Roger's Widget set.
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This is the public header file for the widget.
--    A PixB button can display both a text and a pixmap.
--
--    Resources for the pixel button widget.
--
--    All Core and Primitive resources apply. 
--    The following list describes resources added in this widget.
--  
--    XmNactivateCallback
--      Callback called when button is activated.
--      Type:    XtCallbackList
--      Default: NULL
--  
--    XmNalignment
--      Defines how the components should be aligned.
--      XmALIGNMENT_CENTER centers the components within 
--      the widget and in relation to each other.
--      XmALIGNMENT_BEGINNING positions the components as
--      far to the left and top as possible, XmALIGNMENT_END
--      positions them to the right and bottom.
--      Alignment is used in the dimension that the parts are
--      laid out.
--      Type:    int
--      Default: XmALIGNMENT_CENTER
--  
--    XmNarmCallback
--      Callback called when button is armed.
--      Type:    XtCallbackList
--      Default: NULL
--  
--    XmNdisarmCallback
--      Callback called when button is disarmed.
--      Type:    XtCallbackList
--      Default: NULL
--  
--    XmNfontList
--      Font for label text.
--      Type:    XmFontList
--      Default: Fixed
--  
--    XmNlabelPixmap
--      Pixmap to be displayed in the button.
--      Pixmap is NOT copied locally and should not be deallocated by caller.
--      Type:    Pixmap
--      Default: XmUNSPECIFIED_PIXMAP
--  
--    XmNlabelString
-       String to be displayed in the button.
--      String is copied locally and can be deallocated by caller.
--      Type:    XmString
--      Default: NULL
--  
--    XmNmarginBottom
--      Specifies the amount of spacing between the bottom
--      of the label or pixmap and the top of the bottom
--      margin (specified by XmNmarginHeight).
--      Type:    int
--      Default: 0
--  
--    XmNmarginHeight
--      Specifies the amount of spacing vertically between
--      the shadow and the label or pixmap. The top and
--      bottom margins are added.
--      Type:    int
--      Default: 2
--
--    XmNmarginLeft
--      Specifies the amount of spacing between the left edge
--      of the label or pixmap and the right edge of the left
--      margin (specified by XmNmarginWidth).
--      Type:    int
--      Default: 0
--  
--    XmNmarginRight
--      Specifies the amount of spacing between the right
--      edge of the label or pixmap and the left edge of the
--      right margin (specified by XmNmarginWidth).
--      Type:    int
--      Default: 0
--  
--    XmNmarginTop
--      Specifies the amount of spacing between the top
--      of the label or pixmap and the bottom of the top
--      margin (specified by XmNmarginHeight).
--      Type:    int
--      Default: 0
--  
--    XmNmarginWidth
--      Specifies the amount of spacing horizontally between
--      the shadow and the label or pixmap. The left and
--      right margins are added.
--      Type:    int
--      Default: 2
--  
--    XitRwNoppositeAlignment
--      Defines how the components should be aligned.
--      XmALIGNMENT_CENTER centers the components within 
--      the widget and in relation to each other.
--      XmALIGNMENT_BEGINNING positions the components as
--      far to the left and top as possible, XmALIGNMENT_END
--      positions them to the right and bottom.
--      Alignment is used in the opposite dimension to the one in which
--      the parts are laid out.
--
--      Note! Only implemented for XitRwNpixmapPosition = XitRw(LEFT|RIGHT)!
--
--      Type:    int
--      Default: XmALIGNMENT_CENTER
--  
--    XitRwNpixmapPosition
--      The position of the pixmap relative to the string.
--      XitRwLEFT, XitRwRIGHT, XitRwTOP, XitRwBOTTOM.
--      The resource is only meaningful if both the pixmap 
--      and the string are specified.
--      Type:    int
--      Default: XitRwLEFT
--  
--    XmNrecomputeSize
--      If True, the button requests a new size when new values are set.
--      If False, the button keeps its old size, regardless of the changes that
--      are made to its values.
--      Type:    Boolean
--      Default: False
--
--    XmNshadowType
--      The type of shadow to be drawn around the button in
--      the unarmed state.
--      XmSHADOW_OUT specifies a shadow so that the button
--      protrudes from the background. With XmSHADOW_IN,
--      the button will look like it has been pressed into 
--      the background.
--      When the button is armed, the shadows will be inverted.
--      Type:    int
--      Default: XmSHADOW_OUT
--  
--    XmNspacing
--      Specifies the amount of spacing between the label and the pixmap.
--      Type:    int
--      Default: 2
--
--  Filename:         xitRwPixB.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-17
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitRwPixB.h, Version: 1.1, Date: 95/02/18 15:10:46 */


/* Only include once. */
#ifndef define_xitRwPixB_h
#  define define_xitRwPixB_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

/* Include file for the superclass. */
#include <Xm/Xm.h>

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Resource names. */
#define XitRwNpixmapPosition            "pixmapPosition"
#define XitRwNoppositeAlignment         "oppositeAlignment"

#define XitRwCPixmapPosition            "PixmapPosition"

/* Pixmap positions. */
#define XitRwLEFT        0
#define XitRwRIGHT       1
#define XitRwTOP         2
#define XitRwBOTTOM      3

#ifndef xitRwIsPixButton
#  define xitRwIsPixButton( w ) XtIsSubclass( w, xitRwPixButtonWidgetClass )
#endif


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Class record constants. */
extern WidgetClass xitRwPixButtonWidgetClass;


typedef struct _XitRwPixButtonClassRec *XitRwPixButtonWidgetClass;
typedef struct _XitRwPixButtonRec      *XitRwPixButtonWidget;


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

Boolean
  xitRwPixButIsArmed( Widget  w );


#endif
