/*----------------------------------------------------------------------------
--
--  Module:           xitQuestDia
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Manages an question dialog where Enter and Return are used as 
--    activate keys.
--
--  Filename:         xitQuestDia.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitQuestDia.c, Version: 1.1, Date: 95/02/18 15:10:45";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/MessageB.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void
  removeCB( Widget               widget,
            Widget               toplevel_widget,
            XmAnyCallbackStruct  *call_data );


/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreateQuestionDialog( Widget parent, 
                           char   *dialog_name,
                           char   *title,
                           char   *message,
                           void   (*okCB) (),
                           void   *ok_client_data,
                           void   (*cancelCB) (),
                           void   *cancel_client_data )
{

  /* Variables. */
  Arg        args[ 5 ];
  Cardinal   n;
  Widget     button;
  Widget     w;
  XmString   xstr;


  /* Code. */

  n = 0;
  XtSetArg( args[ n ], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL ); n++;
  XtSetArg( args[ n ], XmNautoUnmanage, False ); n++;
  XtSetArg( args[ n ], XmNnoResize, True ); n++;

  w = XmCreateQuestionDialog( parent, dialog_name, args, n );

  if( strlen( message ) > 0 ) {
    xstr = XmStringCreateLtoR( message, CS );

    n = 0;
    XtSetArg( args[ n ], XmNmessageString, xstr ); n++;
    XtSetValues( w, args, n );
    XmStringFree( xstr );
  }

  if( strlen( title ) > 0 ) {
    xstr = XmStringCreateLtoR( title, CS );

    n = 0;
    XtSetArg( args[ n ], XmNdialogTitle, xstr ); n++;
    XtSetValues( w, args, n );
    XmStringFree( xstr );
  }

  /* Unmanage the help button. */
  button = XmMessageBoxGetChild( w, XmDIALOG_HELP_BUTTON );
  XtUnmanageChild( button );

  /* Add callbacks. */
  if( okCB != NULL ) {
    XtAddCallback( w, XmNokCallback,
                   (XtCallbackProc) okCB, (XtPointer) ok_client_data );
    XtAddCallback( w, XmNokCallback,
                   (XtCallbackProc) removeCB, (XtPointer) w );
  } else {
    XtAddCallback( w, XmNokCallback,
                   (XtCallbackProc) removeCB, (XtPointer) w );
  }

  if( cancelCB != NULL ) {
    XtAddCallback( w, XmNcancelCallback,
                   (XtCallbackProc) cancelCB, (XtPointer) cancel_client_data );
    XtAddCallback( w, XmNcancelCallback,
                   (XtCallbackProc) removeCB, (XtPointer) w );
  } else {
    XtAddCallback( w, XmNcancelCallback,
                   (XtCallbackProc) removeCB, (XtPointer) w );
  }

  XtManageChild( w );

  return( w );

} /* xitCreateQuestionDialog */


/*----------------------------------------------------------------------*/

static void
  removeCB( Widget               widget,
            Widget               toplevel_widget,
            XmAnyCallbackStruct  *call_data )
{

  /* Code. */

  XtDestroyWidget( toplevel_widget );

  return;

} /* removeCB */
