/*----------------------------------------------------------------------------
--
--  Module:           xitInfo
--
--  Project:          xit - X Internal Toolkit
--  System:           <>
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file to module xitInfo.
--
--  Filename:         xitInfo.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-17
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xitInfo.h, Version: 1.1, Date: 95/02/18 15:10:35 */


/* Only include this module once. */
#ifndef define_xitInfo_h
#  define define_xitInfo_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XIT_IN_REASON_DESTROY,
  XIT_IN_REASON_UPDATE,
  XIT_IN_REASON_POPDOWN
} XIT_IN_REASON;


/* Callback function. */
typedef void  ( *XIT_IN_ACTION_CB ) ( XIT_IN_REASON, void * );

/* Handle to the info window. */
typedef void  *XIT_IN_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xitInDestroy( XIT_IN_HANDLE  info_handle );

void
  xitInDisplayToc( XIT_IN_HANDLE  info_handle );

XIT_IN_HANDLE
  xitInInitialize( Widget            parent,
                   XIT_IN_ACTION_CB  actionCB,
                   void              *user_data );

void
  xitInDisplayInfo( XIT_IN_HANDLE  info_handle,
                    char           *book,
                    char           *chapter_id );

void
  xitInDisplayToc( XIT_IN_HANDLE  info_handle );

#endif
