/*----------------------------------------------------------------------------
--
--  Module:           xitError
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Central module to handle error or information messages. 
--    Messages can be Information or Fatal. Information writes
--    a message on stderr (or in a window) and continues execution.
--    Fatal writes a message on stderr and aborts.
--
--  Filename:         xitError.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-08-19
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitError.c, Version: 1.1, Date: 95/02/18 15:10:28";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

#include <X11/Intrinsic.h>

#include "xitTools.h"
#include "xitError.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Name of this application. */
static  char application_name[ 100 ] = "";


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xitErSetApplicationName( char  *name )
{

  /* Code. */

  strcpy( application_name, name );

  return;

} /* xitErSetApplicationName */


/*----------------------------------------------------------------------*/

void
  xitErMessage( Widget               parent,
                XIT_ER_MESSAGE_TYPE  message_type,
                char                 *module,
                char                 *location,
                char                 *message_str )
{

  /* Variables. */
  char    *title;
  Widget  tempW;


  /* Code. */

  if( strlen( application_name ) > 0 )
    title = application_name;
  else
    title = " ";

  /* Message to stderr? */
  if( parent == NULL || message_type == XIT_ER_FATAL ) {
    fprintf( stderr, "%s, %s %s:\n%s\n",
             application_name, module, location, message_str );
  }


  /* Message in a window? */
  if( parent != NULL && message_type != XIT_ER_FATAL ) {

    switch( message_type ) {

      case XIT_ER_ERROR:
        tempW = xitCreateErrorDialog( 
                  parent, "ErrorDialog", 
                  application_name, message_str,
                  NULL, NULL );
        break;

      case XIT_ER_INFO:
        tempW = xitCreateInformationDialog( 
                  parent, "InformationDialog", 
                  application_name, message_str,
                  NULL, NULL );
        break;

      default:
        tempW = xitCreateInformationDialog( 
                  parent, "InformationDialog", 
                  application_name, message_str,
                  NULL, NULL );
        break;

    } /* switch */

  } /* if */


  /* Fatal errors ends the current process. */
  if( message_type == XIT_ER_FATAL ) {
    exit( 1 );
  }


  return;

} /* xitErMessage */
