/*----------------------------------------------------------------------------
--
--  Module:           xitCreMenuPu
--
--  Project:          xit  - X Internal Toolkit
--  System:           xit  - X Internal Toolkit
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Creates a menu push button.
--
--  Filename:         xitCreMenuPu.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-20
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xitCreMenuPu.c, Version: 1.1, Date: 95/02/18 15:10:25";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/SeparatoG.h>
#include <Xm/ToggleB.h>

#include "xitTools.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

Widget 
  xitCreateMenuPushButton( Widget                  parent, 
                           XIT_MENU_BUTTON_STRUCT  *menu )
{

  /* Variables. */
  Arg        args[ 15 ];
  Cardinal   n;
  Widget     w;
  XmString   xstr = NULL;


  /* Code. */

  n = 0;

  /* Create a separator gadget or a push button? */
  if( strcmp( menu -> title, XIT_SEP ) == 0 ) {

    XtSetArg( args[ n ], XmNwidth,     1);      n++;
    XtSetArg( args[ n ], XmNheight,    2);      n++;
    XtSetArg( args[ n ], XmNdepth,     5);      n++;
    XtSetArg( args[ n ], XmNsensitive, False ); n++;

    w = XmCreateSeparatorGadget( parent, menu -> name, args, n );       

  } else {

    if( strlen( menu -> title ) > 0 ) {
      xstr = XmStringCreate( menu -> title, CS );
      XtSetArg( args[ n ], XmNlabelString, xstr ); n++;
    }

    if( strlen( menu -> mnemonic ) > 0 ) {
      XtSetArg( args[ n ], XmNmnemonic, *menu -> mnemonic ); n++;
    }

    if( ! menu -> sensitive ) {
      XtSetArg( args[ n ], XmNsensitive, False ); n++;
    } else {
      XtSetArg( args[ n ], XmNsensitive, True ); n++;
    }

    /* Toggle button or push button? */
    if( menu -> toggle_button ) {

      XtSetArg( args[ n ], XmNindicatorType, XmN_OF_MANY ); n++;

      if( menu -> selected ) {
        XtSetArg( args[ n ], XmNset, True ); n++;
      }

      w = XmCreateToggleButton( parent, menu -> name, args, n );

      if( menu -> callback != NULL )
        XtAddCallback( w, XmNarmCallback, 
                       menu -> callback, menu -> title );

    } else {

      w = XmCreatePushButton( parent, menu -> name, args, n );

      if( menu -> callback != NULL )
        XtAddCallback( w, XmNactivateCallback, 
                       menu -> callback, menu -> title );

    } /* if */

    if( xstr != NULL )
      XmStringFree( xstr );

  } /* if */


  return( w );

} /* xitCreateMenuPushButton */ 
