/*----------------------------------------------------------------------------
--
--  Module:           XmUbDragDrop
--
--  Project:          XmUb - Ulle's Motif widgets
--  System:           
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    This file defines types and atom names that are common for drag and drop
--    operations within XmUbWidgets.
--
--  Filename:         XmUbDragDrop.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-10-15
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: XmUbDragDrop.h, Version: 1.1, Date: 95/02/18 15:10:07 */

#ifndef _XmUbDragDrop_h
#define _XmUbDragDrop_h

/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <stdio.h>
#include <time.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>

/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Atom names. */

#define XmUbDATE_TRANSFER  "XmUbDATE_TRANSFER"

/* Type of transfer. */

#define XmUbTRANSFER_DATE    0
#define XmUbTRANSFER_RANGE   1

/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* The type XmUbDateTransfer is used to transfer a date.
   Atom: XmUbDATE_TRANSFER */

typedef struct {

  /* Type of transfer, date or range. */
  int  type;

  int  year;
  int  month;
  int  day;

  /* Only valid if a range is being transfered. */
  int  end_year;
  int  end_month;
  int  end_day;

} XmUbDateTransfer, *XmUbDateTransferRef;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

#endif


