/*----------------------------------------------------------------------------
--
--  Module:           xtmAfsAclBs
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmAfsAclBs.
--
--  Filename:         xtmAfsAclBs.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-15
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmAfsAclBs.h, Version: 1.1, Date: 95/02/18 15:58:53 */


/* Include this file only once. */
#ifndef define_xtmAfsAclBase_h
#  define define_xtmAfsAclBase_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "Standard.h"
#include "LstLinked.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* We can handle ids up to this length. */
#define XTM_AF_MAX_ID_LENGTH     500

/* Access flags. */
#define XTM_AF_FLAG_READ           1
#define XTM_AF_FLAG_WRITE          2
#define XTM_AF_FLAG_INSERT         4
#define XTM_AF_FLAG_LOOKUP         8
#define XTM_AF_FLAG_DELETE        16
#define XTM_AF_FLAG_LOCK          32
#define XTM_AF_FLAG_ADMINISTER    64

#define XTM_AF_FLAG_ALL     (XTM_AF_FLAG_READ       | XTM_AF_FLAG_WRITE  | \
                             XTM_AF_FLAG_INSERT     | XTM_AF_FLAG_LOOKUP | \
                             XTM_AF_FLAG_DELETE     | XTM_AF_FLAG_LOCK   | \
                             XTM_AF_FLAG_ADMINISTER)

/* Access flags. */
#define XTM_AF_NOID               32766


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Status variable. */
typedef enum {
  XTM_AF_OK, XTM_AF_ERROR
} XTM_AF_STATUS;

/* Acl information. */
typedef struct {
  Boolean  positive;
  UINT32   rights;
  char     id[ XTM_AF_MAX_ID_LENGTH + 1 ];
} XTM_AF_ACL_INFO;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

XTM_AF_STATUS
  xtmAfAccess( char    *filename,
               UINT32  rights );

void
  xtmAfAclFlagToString( UINT32  flags,
                        char    *acl_string );

UINT32
  xtmAfAclStringToFlag( char  *acl_string );

int
  xtmAfFetchId( char  *long_id );

XTM_AF_STATUS
  xtmAfGetAclForFile( char           *filename,
                      LST_DESC_TYPE  *acl_list );

XTM_AF_STATUS
  xtmAfInitialize();

XTM_AF_STATUS
  xtmAfIsAfsFile( char  *filename );

XTM_AF_STATUS
  xtmAfIsAfsMountPoint( char  *dir_path,
                        char  *filename );

XTM_AF_STATUS
  xtmAfSetAclForFile( char           *filename,
                      LST_DESC_TYPE  acl_list );

#endif
