/*----------------------------------------------------------------------------
--
--  Module:           xtmSchedTool
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmSchedTool.c.
--
--  Filename:         xtmSchedTool.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-05-04
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmSchedTool.h, Version: 1.1, Date: 95/02/18 15:52:46 */


/* Only include this module once. */
#ifndef define_xtmSchedTools_h
#  define define_xtmSchedTools_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "TimDate.h"
#include "xtmSchedPriv.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Pick a date from which window. */
typedef enum {
  XTM_ST_PICK_NOTE,
  XTM_ST_PICK_APP
} XTM_ST_PICK_WHAT;

/* Move animation in direction? */
typedef enum {
  XTM_ST_ANI_FORWARD,
  XTM_ST_ANI_BACKWARD,
  XTM_ST_ANI_STILL
} XTM_ST_ANI_DIRECTION;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmStClearEntryTime( SCHED_REC_REF  sched_ref );

ENTRY_INFO
  *xtmStFetchSelectedInfo( SCHED_REC_REF  sched_ref );

Dimension
  xtmStHeightEntry( SCHED_REC_REF  sched_ref,
                    int            duration );

Boolean
  xtmStPickDate( SCHED_REC_REF     sched_ref,
                 XTM_ST_PICK_WHAT  pick_what,
                 TIM_TIME_REF      *picked_date );

Position
  xtmStPositionEntryX( SCHED_REC_REF  sched_ref,
                       int            day_index );

Position
  xtmStPositionEntryY( SCHED_REC_REF  sched_ref,
                       TIM_TIME_REF   entry_start );

Position
  xtmStPositionNoteX( SCHED_REC_REF  sched_ref,
                      int            day_index );

void
  xtmStPosXToDate( SCHED_REC_REF  sched_ref,
                   int            pos_x,
                   TIM_TIME_REF   *new_start_date,
                   int            *new_pos_x );

void
  xtmStPosYToDuration( SCHED_REC_REF  sched_ref,
                       int            pos_y_start,
                       int            pos_y_end,
                       float          grid_minutes,
                       int            *minutes,
                       int            *new_pos_y_end );

void
  xtmStPosYToTime( SCHED_REC_REF  sched_ref,
                   int            pos_y,
                   float          grid_minutes,
                   TIM_TIME_REF   *new_start_time,
                   int            *new_pos_y );

void
  xtmStPresentEntryTime( SCHED_REC_REF         sched_ref,
                         Boolean               only_start_time,
                         Boolean               display_pixmap,
                         XTM_ST_ANI_DIRECTION  ani_direction,
                         TIM_TIME_REF          start_time,
                         int                   duration );

void
  xtmStStartOnDay( SCHED_REC_REF  sched_ref,
                   TIM_TIME_REF   *start_time );

void
  xtmStUpdateMinuteMarker( SCHED_REC_REF  sched_ref );

Dimension
  xtmStWidthEntry( SCHED_REC_REF  sched_ref );

Dimension
  xtmStWidthNote( SCHED_REC_REF  sched_ref );

#endif
