/*----------------------------------------------------------------------------
--
--  Module:           xtmSchedAct
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmSchedAct.c.
--
--  Filename:         xtmSchedAct.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-04-04
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmSchedAct.h, Version: 1.1, Date: 95/02/18 15:52:44 */


/* Only include this module once. */
#ifndef define_xtmSchedAction_h
#  define define_xtmSchedAction_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmSchedPriv.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Operation we can do on the cut buffer. */
typedef enum {
  XTM_SA_DO_CUT,
  XTM_SA_DO_COPY,
  XTM_SA_DO_PASTE
} XTM_SA_CUT_OPERATION;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmSaActionAppHook( Widget         widget,
                      SCHED_REC_REF  sched_ref,
                      XEvent         *event );

void
  xtmSaActionNoteHook( Widget         widget,
                       SCHED_REC_REF  sched_ref,
                       XEvent         *event );

void 
  xtmSaAppointmentEditorShow( SCHED_REC_REF  sched_ref );

void 
  xtmSaAppointmentEditorShowFor( SCHED_REC_REF  sched_ref,
                                 UINT32         entry_id,
                                 char           *calendar,
                                 TIM_TIME_REF   as_date,
                                 TIM_TIME_REF   as_time );

void
  xtmSaDoChangeFlags( SCHED_REC_REF  sched_ref,
                      char           *db_name,
                      int            entry_id,
                      TIM_TIME_REF   date_stamp,
                      UINT32         flags,
                      Boolean        set_flags );

void
  xtmSaDoCutBuffer( SCHED_REC_REF         sched_ref,
                    XTM_SA_CUT_OPERATION  operation,
                    char                  *db_name,
                    UINT32                entry_id );

void
  xtmSaDoNotThisWeek( SCHED_REC_REF  sched_ref,
                      char           *db_name,
                      int            entry_id,
                      TIM_TIME_REF   date_stamp );

void
  xtmSaMapCtrlMenuCB( Widget         widget,
                      SCHED_REC_REF  sched_ref,
                      XtPointer      call_data );

void
  xtmSaMapEditMenuCB( Widget         widget,
                      SCHED_REC_REF  sched_ref,
                      XtPointer      call_data );

void
  xtmSaMapEntryPuMenuCB( Widget         widget,
                         SCHED_REC_REF  sched_ref,
                         XtPointer      call_data );

void
  xtmSaMapFileMenuCB( Widget         widget,
                      SCHED_REC_REF  sched_ref,
                      XtPointer      call_data );

void
  xtmSaStartAnimation( SCHED_REC_REF  sched_ref,
                       XEvent         *event,
                       UINT32         flags,
                       Widget         animateBaseW,
                       Position       start_x,
                       Position       start_y,
                       Dimension      marker_width,
                       Dimension      marker_height );

void
  xtmSaStopAnimation( Widget         widget,
                      SCHED_REC_REF  sched_ref,
                      XEvent         *event );

void
  xtmSaTrackAnimation( Widget         widget,
                       SCHED_REC_REF  sched_ref,
                       XEvent         *event );

#endif
