/*----------------------------------------------------------------------------
--
--  Module:           xtmRemote
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmRemote
--
--  Filename:         xtmRemote.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1993-09-16
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmRemote.h, Version: 1.1, Date: 95/02/18 15:52:42 */


/* Include this file only once. */
#ifndef define_xtmRemote_h
#  define define_xtmRemote_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "xtmCalDb.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_RT_REASON_DESTROY,
  XTM_RT_REASON_APPLY
} XTM_RT_REASON;

/* Upload or download the calendar. */
typedef enum {
  XTM_RT_UPLOAD,
  XTM_RT_DOWNLOAD
} XTM_RT_DIRECTION;

/* Handle to use when comminucating with the window. */
typedef  void  *XTM_RT_HANDLE;

/* Callback when Apply/OK is selected. */
typedef void ( *XTM_RT_ACTION_CB ) (XTM_RT_REASON, void *);


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmRtDestroy( XTM_RT_HANDLE  remote_handle );

void 
  xtmRtDoRemote( XTM_RT_HANDLE     remote_handle,
                 XTM_RT_DIRECTION  direction,
                 char              *calendar,
                 Boolean           can_upload,
                 Boolean           can_download );

XTM_RT_HANDLE
  xtmRtInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   Boolean               appl_modal,
                   XTM_RT_ACTION_CB      actionCB,
                   void                  *user_data );



#endif
