/*----------------------------------------------------------------------------
--
--  Module:           xtmNavCal
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmNavCal.c.
--
--  Filename:         xtmNavCal.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-04-21
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmNavCal.h, Version: 1.1, Date: 95/02/18 15:52:35 */


/* Only include this module once. */
#ifndef define_xtmNavCal_h
#  define define_xtmNavCal_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "TimDate.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_NC_REASON_DATE_SELECT,
  XTM_NC_REASON_DESTROY,
  XTM_NC_REASON_POPDOWN
} XTM_NC_REASON;


/* Handle to use when comminucating with the calendar window. */
typedef  void  *XTM_NC_HANDLE;

/* Callback when the calendar window is cahnged. */
typedef void ( *XTM_NC_ACTION_CB ) ( XTM_NC_REASON, void *, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

XTM_NC_HANDLE
  xtmNcInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   char                  *db_name,
                   Boolean               appl_modal,
                   XTM_NC_ACTION_CB      actionCB,
                   void                  *user_data );

void
  xtmNcDestroy( XTM_NC_HANDLE  nav_cal_handle );

void 
  xtmNcDisplayNavCal( XTM_NC_HANDLE  nav_cal_handle,
                      TIM_TIME_REF   at_date );

void
  xtmNcEmptyCache();

#endif
