/*----------------------------------------------------------------------------
--
--  Module:           xtmHelp
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmHelp.
--
--  Filename:         xtmHelp.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-07-01
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmHelp.h, Version: 1.1, Date: 95/02/18 15:52:24 */


/* Include this file only once. */
#ifndef define_xtmHelp_h
#  define define_xtmHelp_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xitInfo.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Help index to use. */
#define XTM_HL_CONTEXT_INDEX    0
#define XTM_HL_WINDOW_INDEX     1
#define XTM_HL_KEYS_INDEX       2
#define XTM_HL_INDEX_INDEX      3
#define XTM_HL_ON_HELP_INDEX    4
#define XTM_HL_VERSION_INDEX    5


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmHlDisplayAboutWindow( Widget  parentW );

void
  xtmHlDisplayHelp( XIT_IN_HANDLE  info_handle,
                    int            help_index,
                    char           *window_id,
                    char           *widget_id );

void
  xtmHlDisplayReleaseNotes( XIT_IN_HANDLE  info_handle,
                            Widget         parentW );

#endif
