/*----------------------------------------------------------------------------
--
--  Module:           xtmEditSkip
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for xtmEditSkip.c.
--
--  Filename:         xtmEditSkip.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-10-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmEditSkip.h, Version: 1.1, Date: 95/02/18 15:52:17 */


/* Only include this module once. */
#ifndef define_xtmEditSkip_h
#  define define_xtmEditSkip_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "TimDate.h"
#include "xtmGlobal.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Values passed to the window. */
typedef struct {
  UINT32        skip_week[ 2 ];
  TIM_TIME_REF  default_date;
} XTM_EK_SET_SKIP_DATA;

/* Result values passed from the preference window. */
typedef struct {
  UINT32  skip_week[ 2 ];
} XTM_EK_GET_SKIP_DATA;


/* Reasons when the action routine is called. */
typedef enum {
  XTM_EK_REASON_CANCEL,
  XTM_EK_REASON_DESTROY,
  XTM_EK_REASON_OK
} XTM_EK_REASON;

/* Callback when the alarm window is destroyed. */
typedef void ( *XTM_EK_ACTION_CB ) ( XTM_EK_REASON, 
                                     void *, XTM_EK_GET_SKIP_DATA * );

/* Handle to use when comminucating with the window. */
typedef  void  *XTM_EK_HANDLE;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

void
  xtmEkDestroy( XTM_EK_HANDLE  skip_handle );

void
  xtmEkEditSkip( XTM_EK_HANDLE         skip_handle,
                 XTM_EK_SET_SKIP_DATA  *values_ref );

XTM_EK_HANDLE
  xtmEkInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   XTM_EK_ACTION_CB      actionCB,
                   void                  *user_data );

#endif

