/*----------------------------------------------------------------------------
--
--  Module:           xtmDbFilter
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmDbFilter.
--
--  Filename:         xtmDbFilter.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-01-25
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmDbFilter.h, Version: 1.1, Date: 95/02/18 15:52:08 */


/* Include this file only once. */
#ifndef define_xtmDbFilter_h
#  define define_xtmDbFilter_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmGlobal.h"
#include "xtmDbMisc.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Max entry tags in a menu, how many? */
#define XTM_FI_MAX_MENU_TAGS      20



/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_FI_REASON_OK,
  XTM_FI_REASON_APPLY,
  XTM_FI_REASON_CANCEL,
  XTM_FI_REASON_DESTROY
} XTM_FI_REASON;

/* Handle to use when comminucating with the filter window. */
typedef  void  *XTM_FI_HANDLE;

/* Callback when Apply/OK is selected. */
typedef void ( *XTM_FI_ACTION_CB ) (XTM_FI_REASON,
                                    XTM_DM_FILTER_REC *, void *);


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmFiDestroy( XTM_FI_HANDLE  filter_handle );

void
  xtmFiDisplayFilterWindow( XTM_FI_HANDLE      filter_handle,
                            XTM_DM_FILTER_REC  *use_filter_ref );

XTM_FI_HANDLE
  xtmFiInitialize( XTM_GL_BASE_DATA_REF  appl_data_ref,
                   Widget                parent,
                   char                  *tags_menu,
                   Boolean               app_modal,
                   XTM_FI_ACTION_CB      actionCB,
                   void                  *user_data );

#endif
