/*----------------------------------------------------------------------------
--
--  Module:           xtmDateSel
--
--  Project:          Xdiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Select a yaer and month.
--
--  Filename:         xtmDateSel.c
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1992-06-10
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
static char SCCSID[] = "@(#) Module: xtmDateSel.c, Version: 1.1, Date: 95/02/18 15:52:07";


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/List.h>
#include <Xm/Scale.h>

#include "System.h"
#include "Message.h"

#include "msgXdiary.h"
#include "xtmGlobal.h"
#include "xitError.h"
#include "xitTools.h"
#include "xtmDateSel.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/

/* Local widgets in the show window. */
#define fpMonthLa           dataLocalW[  0 ]
#define fpMonthLi           dataLocalW[  1 ]
#define fpYearLa            dataLocalW[  2 ]
#define fpYearSc            dataLocalW[  3 ]


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Record for date select. */
typedef struct {

  /* The date select window. */
  Widget  selectW;

  /* Selected month. */
  int  month;

  /* Callback to inform our creator of specific actions. */
  void              *user_data;
  XTM_DS_ACTION_CB  actionCB;

} SELECT_REC, *SELECT_REC_REF;


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/

/* Name of module. */
static char  *module_name = "xtmDateSelect";


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/

static void 
  destroyCB( Widget          widget,
             SELECT_REC_REF  select_ref,
             XtPointer       call_data );

static void 
  monthSelectCB( Widget                widget, 
                 SELECT_REC_REF        select_ref,
                 XmListCallbackStruct  *call_data );

static void 
  okCB( Widget          widget,
        SELECT_REC_REF  select_ref,
        XtPointer       call_data );

static void 
  todayCB( Widget          widget,
           SELECT_REC_REF  select_ref,
           XtPointer       call_data );



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void 
  xtmDsCreateSelectYearMonth( Widget            parent,
                              TIM_TIME_REF      current_date,
                              XTM_DS_ACTION_CB  actionCB,
                              void              *user_data )
{

  /* Variables. */
  int             index;
  char            buffer[ 100 ];
  Arg             args[ 10 ];
  Cardinal        n;
  Widget          dataLocalW[ 4 ];
  Widget          fastPathFd;
  Widget          workFo;
  XmString        list_items[ 20 ];
  SELECT_REC_REF  select_ref;
  TIM_TIME_REF    time_ref;

  static XIT_ACTION_AREA_ITEM  action_buttons[] = {
    { "", okCB,    NULL },
    { "", todayCB, NULL },
    { "", NULL,    NULL },
  };


  /* Code. */

  /* Create and initialize our private data. */
  select_ref = SysNew( SELECT_REC );
  if( select_ref == NULL )
    return;

  select_ref -> actionCB   = actionCB;
  select_ref -> user_data  = user_data;


  /* Get text for menues and buttons. */
  action_buttons[ 0 ].label = msgGetText( MXDI_OK_BUTTON );
  action_buttons[ 0 ].data  = select_ref;
  action_buttons[ 1 ].label = msgGetText( MXDI_TODAY_LABEL );
  action_buttons[ 1 ].data  = select_ref;
  action_buttons[ 2 ].label = msgGetText( MXDI_CANCEL_BUTTON );
  action_buttons[ 2 ].data  = select_ref;


  /* Create a separate window. */
  fastPathFd = xitCreateFormDialog( parent, "FastPathFd",
                                    1, 0,
                                    action_buttons,
                                    XtNumber( action_buttons ) );

  XtAddCallback( fastPathFd, XmNdestroyCallback, 
                 (XtCallbackProc) destroyCB, (XtPointer)  select_ref );

  n = 0;
  XtSetArg( args[ n ], XmNtitle, msgGetText( MXDI_DATE_SELECT_TITLE ) ); n++;
  XtSetValues( XtParent( fastPathFd ), args, n );

  n = 0;
  XtSetArg( args[ n ], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL ); n++;
  XtSetValues( fastPathFd, args, n );


  /* Container for the contents of the window. */
  workFo = XtNameToWidget( fastPathFd, "FastPathFdFo" );


  /* Scale with valid years. */
  fpYearLa = xitCreateLabel( workFo, "FpYearLa", 
                             msgGetText( MXDI_YEAR_LABEL ), -1 );

  n = 0;
  XtSetArg( args[ n ], XmNvalue, 1971 ); n++;
  XtSetArg( args[ n ], XmNminimum, 1971 ); n++;
  XtSetArg( args[ n ], XmNmaximum, 2040 ); n++;
  XtSetArg( args[ n ], XmNprocessingDirection, XmMAX_ON_BOTTOM ); n++;
  XtSetArg( args[ n ], XmNshowValue, True ); n++;
  XtSetArg( args[ n ], XmNorientation, XmVERTICAL ); n++;
  fpYearSc = XmCreateScale( workFo, "FpYearSc", args, n );


  /* List with months. */
  fpMonthLa = xitCreateLabel( workFo, "FpMonthLa", 
                              msgGetText( MXDI_MONTH_LABEL ), -1 );

  n = 0;
  XtSetArg( args[ n ], XmNlistSizePolicy,         XmCONSTANT ); n++;
  XtSetArg( args[ n ], XmNscrollBarDisplayPolicy, XmSTATIC ); n++;
  XtSetArg( args[ n ], XmNselectionPolicy,        XmSINGLE_SELECT ); n++;
  XtSetArg( args[ n ], XmNlistMarginHeight,       5 ); n++;
  XtSetArg( args[ n ], XmNlistMarginWidth,        5 ); n++;
  fpMonthLi = XmCreateScrolledList( workFo, "FpMonthLi", args, n );

  XtAddCallback( fpMonthLi, XmNsingleSelectionCallback,
                 (XtCallbackProc) monthSelectCB, (XtPointer) select_ref );
  XtAddCallback( fpMonthLi, XmNdefaultActionCallback,
                 (XtCallbackProc) monthSelectCB, (XtPointer) select_ref );


  /* Put the parts together. */
  xitAttachWidget( fpMonthLa,
                   XmATTACH_FORM, NULL, XmATTACH_FORM, NULL,
                   XmATTACH_NONE, NULL, XmATTACH_NONE, NULL );
  xitAttachWidget( XtParent( fpMonthLi ),
                   XmATTACH_WIDGET, fpMonthLa, XmATTACH_FORM, NULL,
                   XmATTACH_WIDGET, fpYearSc,  XmATTACH_NONE, NULL );
  xitAttachWidget( fpYearLa,
                   XmATTACH_FORM, NULL, XmATTACH_NONE, NULL,
                   XmATTACH_FORM, NULL, XmATTACH_NONE, NULL );
  xitAttachWidget( fpYearSc,
                   XmATTACH_WIDGET, fpYearLa, XmATTACH_NONE, NULL,
                   XmATTACH_FORM,   NULL,     XmATTACH_NONE, NULL );

  /* Make sure there is enough space between the children. */
  n = 0;
  XtSetArg( args[ n ], XmNtopOffset,    5  ); n++;
  XtSetArg( args[ n ], XmNleftOffset,   10 ); n++;
  XtSetArg( args[ n ], XmNrightOffset,  0  ); n++;
  XtSetArg( args[ n ], XmNbottomOffset, 5  ); n++;
  XtSetValues( fpMonthLa,             args, n );
  XtSetValues( XtParent( fpMonthLi ), args, n );

  n = 0;
  XtSetArg( args[ n ], XmNtopOffset,    5  ); n++;
  XtSetArg( args[ n ], XmNleftOffset,   0  ); n++;
  XtSetArg( args[ n ], XmNrightOffset,  10 ); n++;
  XtSetArg( args[ n ], XmNbottomOffset, 5  ); n++;
  XtSetValues( fpYearLa,              args, n );
  XtSetValues( fpYearSc,              args, n );

  /* Manage all the children. */
  xitManageChildren( dataLocalW, XtNumber( dataLocalW ) );

  /* Set the size of the window. */
  xitSetSizeFormDialog( fastPathFd, True );


  /* Make the final attachments. */
  n = 0;
  XtSetArg( args[ n ], XmNbottomAttachment, XmATTACH_FORM ); n++;
  XtSetValues( XtParent( fpMonthLi ), args, n );
  XtSetValues( fpYearSc,              args, n );


  XtManageChild( fastPathFd );


  /* Set the name of the months and select the correct month. */
  time_ref = TimMakeTime( 1970, 1, 1, 0, 0, 0 );

  for( index = 0; index < 12; index++ ) {
    TimFormatStrTime( time_ref, "%B", buffer, sizeof( buffer ) );

    list_items[ index ] = XmStringCreate( buffer, CS );

    TimAddMonths( &time_ref, 1 );
  }

  n = 0;
  XtSetArg( args[ n ], XmNitems, list_items ); n++;
  XtSetArg( args[ n ], XmNitemCount, 12 ); n++;
  XtSetValues( fpMonthLi, args, n );

  XmListSelectPos( fpMonthLi, TimIndexOfMonth( current_date ), True );


  /* Set the year. */
  XmScaleSetValue( fpYearSc, TimIndexOfYear( current_date ) );


  select_ref -> selectW = fastPathFd;


  return;

} /* xtmDsCreateSelectYearMonth */


/*----------------------------------------------------------------------*/

static void 
  destroyCB( Widget          widget,
             SELECT_REC_REF  select_ref,
             XtPointer       call_data )
{

  /* Code. */

  /* Release the user data. */
  SysFree( select_ref );


  return;

} /* destroyCB */


/*----------------------------------------------------------------------*/

static void 
  monthSelectCB( Widget                widget, 
                 SELECT_REC_REF        select_ref,
                 XmListCallbackStruct  *call_data )
{

  /* Code. */

  select_ref -> month = call_data -> item_position;


  return;

} /* monthSelectCB */


/*----------------------------------------------------------------------*/

static void 
  okCB( Widget          widget,
        SELECT_REC_REF  select_ref,
        XtPointer       call_data )
{

  /* Variables. */
  int     year;
  Widget  mainW;
  Widget  tempW;


  /* Code. */

  mainW = XtNameToWidget( select_ref -> selectW, "FastPathFdFo" );

  /* The selected year. */
  tempW = XtNameToWidget( mainW, "FpYearSc" );
  XmScaleGetValue( tempW, &year );


  /* Do we have a user action callback registered? */
  if( select_ref -> actionCB != NULL )
    (* select_ref -> actionCB)( XTM_DS_REASON_OK, 
                                year, select_ref -> month, 1,
                                select_ref -> user_data );

  XtDestroyWidget( select_ref -> selectW );


  return;

} /* okCB */


/*----------------------------------------------------------------------*/

static void 
  todayCB( Widget          widget,
           SELECT_REC_REF  select_ref,
           XtPointer       call_data )
{

  /* Code. */

  /* Do we have a user action callback registered? */
  if( select_ref -> actionCB != NULL )
    (* select_ref -> actionCB)( XTM_DS_REASON_TODAY, 
                                1970, 1, 1,
                                select_ref -> user_data );

  XtDestroyWidget( select_ref -> selectW );


  return;

} /* todayCB */


