/*----------------------------------------------------------------------------
--
--  Module:           xtmCustIncl
--
--  Project:          XDiary
--  System:           xtm - X Desktop Calendar
--    Subsystem:      <>
--    Function block: <>
--
--  Description:
--    Interface file for module xtmCustIncl.
--
--  Filename:         xtmCustIncl.h
--
--  Authors:          Roger Larsson, Ulrika Bornetun
--  Creation date:    1991-10-15
--
--
--  (C) Copyright Ulrika Bornetun, Roger Larsson (1995)
--      All rights reserved
--
--  Permission to use, copy, modify, and distribute this software and its
--  documentation for any purpose and without fee is hereby granted,
--  provided that the above copyright notice appear in all copies. Ulrika
--  Bornetun and Roger Larsson make no representations about the usability
--  of this software for any purpose. It is provided "as is" without express
--  or implied warranty.
----------------------------------------------------------------------------*/

/* SCCS module identifier. */
/* SCCSID = @(#) Module: xtmCustIncl.h, Version: 1.1, Date: 95/02/18 15:52:06 */


/* Include this file only once. */
#ifndef define_xtmCustInclude_h
#  define define_xtmCustInclude_h


/*----------------------------------------------------------------------------
--  Include files
----------------------------------------------------------------------------*/

#include "xtmCalDb.h"
#include "xtmCustom.h"


/*----------------------------------------------------------------------------
--  Macro definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Type declarations
----------------------------------------------------------------------------*/

/* Reasons when the action routine is called. */
typedef enum {
  XTM_CI_REASON_OK,
  XTM_CI_REASON_DESTROY,
  XTM_CI_REASON_POPDOWN
} XTM_CI_REASON;

/* Handle to use when comminucating with the calendar window. */
typedef  void  *XTM_CI_HANDLE;

/* Callback from the calendar window. */
typedef void ( *XTM_CI_ACTION_CB ) ( XTM_CI_REASON, 
                                     char *, XTM_CD_INCL_CALS *, void * );


/*----------------------------------------------------------------------------
--  Global definitions
----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
--  Function prototypes
----------------------------------------------------------------------------*/



/*----------------------------------------------------------------------------
--  Functions
----------------------------------------------------------------------------*/

void
  xtmCiDestroy( XTM_CI_HANDLE  incl_handle );

XTM_CI_HANDLE
  xtmCiInitialize( XTM_GL_CUSTOM_DATA_REF  custom_data_ref,
                   Widget                  parent,
                   XTM_CI_ACTION_CB        actionCB,
                   void                    *user_data );

void 
  xtmCiEditCustInclude( XTM_CI_HANDLE  incl_handle,
                        XTM_CD_HANDLE  cal_db_handle,
                        char           *db_name );

#endif
