/*      -------------------------------------------------------------------
	xldlas -- A Stastics Package

	Copyright (C) 1996 Thor Sigvaldason

	Handles all graphing routines, both the oncsreen ones using
	xforms routines and the calling of gnuplot for exporting graphs 
	to all the file formats supported by gnuplot
	
        -------------------------------------------------------------------*/

#include "xldlas.h"

extern void simple_line_output(char which_routine[XLDLASMAX_INPUT], char the_output[XLDLASMAX_INPUT]);
extern void begin_column_output(char the_output[XLDLASMAX_INPUT], int justify);
extern void add_column_output(char the_output[XLDLASMAX_INPUT], int justify);
extern void end_column_output();
extern void seperator_output(int how_many);
extern void begin_table_output(int how_many, char title[XLDLASMAX_INPUT]);
extern void end_table_output(int how_many);

extern void say_status(char the_status[XLDLASMAX_INPUT]);

extern void graph_output(char save_name[XLDLASMAX_INPUT], int the_xvar, int the_variables[], int how_many);

extern void sort_working_vector();

void sync_graph_browsers(int type)
/* type 0 = a new variable created, 1 = exisiting fit overwritten, 2 (or greater) = data dropped) */
{
	int i;
	int largest;
	largest = 0;
	if(type == 0)
	{
		for(i=0; i < numb_variables; i++)
		{
			if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
		}
		fl_set_counter_bounds(graph_from_counter, 1, largest);
		fl_set_counter_bounds(graph_to_counter, 1, largest);
		fl_addto_browser(xvar_browser,data_matrix[numb_variables - 1].name);
		fl_addto_browser(yvar_browser,data_matrix[numb_variables - 1].name);
		point_style[numb_variables - 1] = 0;
		line_style[numb_variables - 1] = ((numb_variables - 1) % 6) + 1 ;
		return;
	}
	if(type == 1)
	{
		for(i=0; i < numb_variables; i++)
		{
			if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
		}
		fl_set_counter_bounds(graph_from_counter, 1, largest);
		fl_set_counter_bounds(graph_to_counter, 1, largest);
		return;
	}
	
	fl_clear_browser(xvar_browser);
	fl_clear_browser(yvar_browser);
	largest = 0;
	for(i=0; i < numb_variables; i++)
	{
		if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
		fl_addto_browser(xvar_browser,data_matrix[i].name);
		fl_addto_browser(yvar_browser,data_matrix[i].name);
		point_style[i] = 0;
		line_style[i] = (i % 6) + 1 ;
	}
	fl_set_counter_value(graph_from_counter, 1);
	fl_set_counter_bounds(graph_from_counter, 1, largest);
	fl_set_counter_step(graph_from_counter, 1, 10);

	fl_set_counter_value(graph_to_counter, largest);
	fl_set_counter_bounds(graph_to_counter, 1, largest);
	fl_set_counter_step(graph_to_counter, 1, 10);
}

void inhibit_graph_input()
{
	fl_deactivate_object(graph_menu);
	fl_set_object_lcol(graph_menu, FL_INACTIVE);
	fl_deactivate_object(plot_button);
	fl_set_object_lcol(plot_button, FL_INACTIVE);
	graph_window_open = TRUE;
}

void reenable_graph_input()
{
	fl_activate_object(graph_menu);
	fl_set_object_lcol(graph_menu, FL_BLACK);
	fl_activate_object(plot_button);
	fl_set_object_lcol(plot_button, FL_BLACK);
	graph_window_open = FALSE;
}

void set_graph_range_counters(FL_OBJECT *obj, long arg)
{
	int i,j;
	float biggest, smallest;
	int to_check[MAX_VARS], numb_check;
	int start_check, stop_check;
	if(arg == 1 && fl_get_button(graph_xrange_auto_button) == 0)
	{
		start_check = fl_get_counter_value(graph_from_counter);
		stop_check = fl_get_counter_value(graph_to_counter);
		if(stop_check < start_check)
		{
			stop_check = 1;
			start_check = 1;
		}
		numb_check = -1;
		for(i=0 ; i< numb_variables; i++)
		{
			if(fl_isselected_browser_line(xvar_browser, i+1))
			{
				numb_check = i;
				i = numb_variables;
			}
		}
		if(numb_check > -1)
		{
			biggest = *(fvector[numb_check] + start_check - 1);
			smallest = *(fvector[numb_check] + start_check - 1);
			for(i = start_check; i < stop_check; i ++)
			{
				if(i < data_matrix[numb_check].obs)
				{
					if(smallest == missing_value || smallest > *(fvector[numb_check] + i))
					{
						smallest = *(fvector[numb_check] + i);
					}
					if(biggest == missing_value || biggest < *(fvector[numb_check] + i))
					{
						biggest = *(fvector[numb_check] + i);
					}
				}
			}
			fl_set_counter_value(graph_xrange_from_counter, smallest);
			fl_set_counter_step(graph_xrange_from_counter, 0.1, (biggest - smallest) / 20);
			fl_set_counter_value(graph_xrange_to_counter, biggest);
			fl_set_counter_step(graph_xrange_to_counter, 0.1, (biggest - smallest) / 20);
		}	
	}
	if(arg == 2 && fl_get_button(graph_yrange_auto_button) == 0)
	{
		start_check = fl_get_counter_value(graph_from_counter);
		stop_check = fl_get_counter_value(graph_to_counter);
		if(stop_check < start_check)
		{
			stop_check = 1;
			start_check = 1;
		}
		numb_check = 0;
		for(i=0 ; i< numb_variables; i++)
		{
			if(fl_isselected_browser_line(yvar_browser, i+1))
			{
				to_check[numb_check] = i;
				numb_check++;
			}
		}
		if(numb_check > 0)
		{
			biggest = *(fvector[to_check[0]] + start_check - 1);
			smallest = *(fvector[to_check[0]] + start_check - 1);
			for(i = start_check; i < stop_check; i ++)
			{
				for(j = 0; j < numb_check; j++)
				{
					if(i < data_matrix[to_check[j]].obs)
					{
						if(smallest == missing_value || smallest > *(fvector[to_check[j]] + i))
						{
							smallest = *(fvector[to_check[j]] + i);
						}
						if(biggest == missing_value || biggest < *(fvector[to_check[j]] + i))
						{
							biggest = *(fvector[to_check[j]] + i);
						}
					}
				}
			}
			fl_set_counter_value(graph_yrange_from_counter, smallest);
			fl_set_counter_step(graph_yrange_from_counter, 0.1, (biggest - smallest) / 20);
			fl_set_counter_value(graph_yrange_to_counter, biggest);
			fl_set_counter_step(graph_yrange_to_counter, 0.1, (biggest - smallest) / 20);
		}	
	}
}

void do_system_call(char the_command[XLDLASMAX_INPUT])
{
	int error;
	error = system(the_command);
	if(error == 127 || error == -1)
	{
		fl_show_alert("The following system call failed:", the_command, "", TRUE);
	}
}



void graph_set_bar(FL_OBJECT *obj, long arg)
{
	numb_bars = fl_get_counter_value(graph_bar_counter);
}

void graph_toggles(FL_OBJECT *obj, long arg)
{
	if(arg == 1)
	{
		if(graph_key_on == TRUE)
			graph_key_on = FALSE;
		else
			graph_key_on = TRUE; 
	}
	if(arg == 2)
	{
		if(graph_overwrite_on == TRUE)
			graph_overwrite_on = FALSE;
		else
			graph_overwrite_on = TRUE; 
	}
	if(arg == 3)
	{
		if(graph_normal_on == TRUE)
			graph_normal_on = FALSE;
		else
			graph_normal_on = TRUE; 
	}
	fl_set_button(graph_normal_button, 0);
	fl_set_button(graph_normal_button, 0);
	fl_set_button(graph_overwrite_button, 0);
	if(graph_key_on == TRUE)
	{
		fl_set_button(graph_key_button, 1);
	}
	if(graph_normal_on == TRUE)
	{
		fl_set_button(graph_normal_button, 1);
	}
	if(graph_overwrite_on == TRUE)
	{
		fl_set_button(graph_overwrite_button, 1);
	}
}

void done_attributes(FL_OBJECT *obj, void *arg)
{
	line_style[temp_varnumber] = fl_get_counter_value(att_line_counter);
	point_style[temp_varnumber] = fl_get_counter_value(att_point_counter);
	fl_hide_form(att_window);
}

int click_done_attributes(FL_FORM *form, long arg)
{
	line_style[temp_varnumber] = fl_get_counter_value(att_line_counter);
	point_style[temp_varnumber] = fl_get_counter_value(att_point_counter);
	return(FL_OK);
}

int launch_gnuplot()
{
	int gnu_pipes[2];
	pipe(gnu_pipes);
	gnuplot_pid = fork();
	switch(gnuplot_pid)
	{
		case -1:	fl_show_alert("I Can't Start GNUPlot (fork() failed)","","",TRUE);
				return(-1);

		case 0:		close(0);
				dup(gnu_pipes[0]);
				close(gnu_pipes[0]);
				close(gnu_pipes[1]);
				execlp("gnuplot", "gnuplot", "-geometry", gnuplot_geometry, "-title", "'Gnuplot via xldlas'", (char *)0);
				printf("Message from an xldlas child: I can't run gnuplot!!\n");
				exit(0);

		case 1:		close(gnu_pipes[0]);
				return(-1);	
	}
	return(gnu_pipes[1]);
}




void handle_graph_choices(FL_OBJECT *obj, long arg)
{
	fl_set_button(choose_hist_button,0);
	fl_set_button(choose_plot_button,0);
	if(arg == 1)
	{
		fl_set_button(choose_hist_button,1);
	}
	else
	{
		fl_set_button(choose_plot_button,1);
	}
}

void handle_graph_browsers(FL_OBJECT *obj, long arg)
{
	int which;
	char string_one[XLDLASMAX_INPUT];
	which = fl_get_browser(yvar_browser);
	if(which > 0)
	{
		temp_varnumber = which - 1;
		fl_set_counter_value(att_line_counter, line_style[which - 1]);
		fl_set_counter_bounds(att_line_counter, 0, 7);
		fl_set_counter_step(att_line_counter, 1, 1);
		fl_set_counter_value(att_point_counter, point_style[which - 1]);
		fl_set_counter_bounds(att_point_counter, 0, 7);
		fl_set_counter_step(att_point_counter, 1, 1);
		sprintf(string_one,"Plot Attributes of %s", data_matrix[which-1].name);
		fl_show_form(att_window,FL_PLACE_FREE,FL_TRANSIENT,string_one);
	}
}

void do_logo_plot()
{
	char string_one[XLDLASMAX_INPUT];
	tmpnam(gnuplot_datafile_name);
	gnuplot_datafile = fopen(gnuplot_datafile_name, "w");
	fprintf(gnuplot_datafile, "1 1\n");
	fprintf(gnuplot_datafile, "3 4\n");
	fprintf(gnuplot_datafile, "\n");
	fprintf(gnuplot_datafile, "1 4\n");
	fprintf(gnuplot_datafile, "3 1\n");
	fprintf(gnuplot_datafile, "\n");
	fprintf(gnuplot_datafile, "4 1\n");
	fprintf(gnuplot_datafile, "4 7\n");
	fprintf(gnuplot_datafile, "\n");
	fprintf(gnuplot_datafile, "5 1\n");
	fprintf(gnuplot_datafile, "5 4\n");
	fprintf(gnuplot_datafile, "7 4\n");
	fprintf(gnuplot_datafile, "7 1\n");
	fprintf(gnuplot_datafile, "5 1\n");
	fprintf(gnuplot_datafile, "\n");
	fprintf(gnuplot_datafile, "7 1\n");
	fprintf(gnuplot_datafile, "7 7\n");
	fprintf(gnuplot_datafile, "\n");
	fprintf(gnuplot_datafile, "8 1\n");
	fprintf(gnuplot_datafile, "8 7\n");
	fprintf(gnuplot_datafile, "\n");
	
	fprintf(gnuplot_datafile, "11 2.5\n");
	fprintf(gnuplot_datafile, "11 1\n");
	fprintf(gnuplot_datafile, "9 1\n");
	fprintf(gnuplot_datafile, "9 2.5\n");
	fprintf(gnuplot_datafile, "11 2.5\n");
	fprintf(gnuplot_datafile, "11 4\n");
	fprintf(gnuplot_datafile, "9 4\n");
	fprintf(gnuplot_datafile, "\n");
	fprintf(gnuplot_datafile, "12 1\n");
	fprintf(gnuplot_datafile, "14 1\n");
	fprintf(gnuplot_datafile, "14 2.5\n");
	fprintf(gnuplot_datafile, "12 2.5\n");
	fprintf(gnuplot_datafile, "12 4\n");
	fprintf(gnuplot_datafile, "14 4\n");
	write(gnuplot_pipe, "set xrange[0:15]\n", strlen("set xrange[0:15]\n"));
	write(gnuplot_pipe, "set yrange[0:8]\n", strlen("set yrange[0:9]\n"));
	write(gnuplot_pipe, "set nokey\n", strlen("set nokey\n")); 
	sprintf(string_one, "plot '%s' using 1:2 w l 1\n",gnuplot_datafile_name);
	write(gnuplot_pipe, string_one, strlen(string_one));
	fclose(gnuplot_datafile);
}

int save_graph(char graph_name[XLDLASMAX_INPUT])
{
	char string_one[XLDLASMAX_INPUT];
	FILE *file_pointer;
	file_pointer = fopen(graph_name,"r");
	if(file_pointer && graph_overwrite_on == FALSE)
	{
		fl_show_alert("Save File already Exists","","",TRUE);
		return(FALSE);
	}
	fclose(file_pointer);
	strcpy(graph_output_format, fl_get_input(graph_format_input));
	strcpy(graph_output_options, fl_get_input(graph_options_input));
	sprintf(string_one,"set term %s %s\n", graph_output_format, graph_output_options);
	write(gnuplot_pipe, string_one, strlen(string_one));
	sprintf(string_one,"set output '%s'\n", graph_name);
	write(gnuplot_pipe, string_one, strlen(string_one));
	write(gnuplot_pipe, "replot\n", strlen("replot\n"));
	write(gnuplot_pipe,"set term x11\n", strlen("set term x11\n"));
	write(gnuplot_pipe,"set output\n",strlen("set output\n"));
	write(gnuplot_pipe, "replot\n", strlen("replot\n"));
	return(TRUE);
}

void graph_variables()
{
	int i,j,k;
	int toplot[MAX_VARS];
	int numbplot;
	int xvar;
	char string_one[XLDLASMAX_INPUT];
	numbplot = 0;
	xvar = -1;
	for(i=0; i < numb_variables;i++)
	{
		if(fl_isselected_browser_line(xvar_browser, i+1))
		{
			xvar = i;
			i = numb_variables;
		}
	}
	if(xvar == -1)
	{
		fl_show_alert("No X variable selected","","",TRUE);
		return;
	}
	for(i=0; i < numb_variables;i++)
	{
		if(fl_isselected_browser_line(yvar_browser, i+1))
		{
			toplot[numbplot] = i;
			numbplot++;
		}
	}
	if(numbplot == 0)
	{
		fl_show_alert("No Y variable(s) selected","","",TRUE);
		return;
	}
	all_start = fl_get_counter_value(graph_from_counter);
	all_stop = fl_get_counter_value(graph_to_counter);
	if(all_stop < all_start)
	{
		fl_show_alert("From Value Greater than to Value!",
			      "",
			      "",
			      TRUE);
		return;
	}
	if(all_stop == all_start)
	{
		fl_show_alert("You're trying to Graph a Single Point in Two Dimension",
			      "(I'm letting you go ahead, but gnuplot will complain)",
			      "",
			      TRUE);
	}
	gnuplot_datafile = fopen(gnuplot_datafile_name,"w");
	write(gnuplot_pipe,"set autoscale\n", strlen("set autoscale\n"));
	if(fl_get_button(graph_xrange_auto_button) != 1)
	{
		if(fl_get_counter_value(graph_xrange_from_counter) == fl_get_counter_value(graph_xrange_to_counter))
		{
			fl_set_counter_value(graph_xrange_to_counter, fl_get_counter_value(graph_xrange_from_counter) + 0.1);
		}	
		sprintf(string_one,"set xrange[%f:%f]\n", fl_get_counter_value(graph_xrange_from_counter), fl_get_counter_value(graph_xrange_to_counter));
		write(gnuplot_pipe, string_one, strlen(string_one));
	}
	if(fl_get_button(graph_yrange_auto_button) != 1)
	{
		if(fl_get_counter_value(graph_yrange_from_counter) == fl_get_counter_value(graph_yrange_to_counter))
		{
			fl_set_counter_value(graph_yrange_to_counter, fl_get_counter_value(graph_yrange_from_counter) + 0.1);
		}	
		sprintf(string_one,"set yrange[%f:%f]\n", fl_get_counter_value(graph_yrange_from_counter), fl_get_counter_value(graph_yrange_to_counter));
		write(gnuplot_pipe, string_one, strlen(string_one));
	}
	if(graph_key_on == TRUE) write(gnuplot_pipe, "set key\n", strlen("set key\n"));
	else write(gnuplot_pipe, "set nokey\n", strlen("set nokey\n"));
	for(j = all_start - 1; j < all_stop; j++)
	{
		if(*(fvector[xvar] + j) == missing_value || data_matrix[xvar].obs <= j)
		{
			fprintf(gnuplot_datafile,"\n");
		}
		else
		{
			fprintf(gnuplot_datafile, "%f\t",*(fvector[xvar] + j));
			for(k =0; k < numbplot; k++)
			{
				if(data_matrix[toplot[k]].obs <= j)
				{
					fprintf(gnuplot_datafile,";\t");
				}
				else
				{
					if(*(fvector[toplot[k]] + j) == missing_value)
						fprintf(gnuplot_datafile,";\t");
					else
						fprintf(gnuplot_datafile,"%f\t", *(fvector[toplot[k]] + j));
				}
			}
			fprintf(gnuplot_datafile,"\n");
		}
	}
	fclose(gnuplot_datafile);
	strcpy(string_one,fl_get_input(graph_title_input));
	if(strlen(string_one) > 0)
	{
		write(gnuplot_pipe,"set title \"", strlen("set title \""));
		strcat(string_one,"\"\n");
		write(gnuplot_pipe,string_one,strlen(string_one)); 
	}
	else
	{
		write(gnuplot_pipe,"set title\n", strlen("set title\n"));
	}
	strcpy(string_one,fl_get_input(graph_xlabel_input));
	if(strlen(string_one) > 0)
	{
		write(gnuplot_pipe,"set xlabel \"", strlen("set xlabel \""));
		strcat(string_one,"\"\n");
		write(gnuplot_pipe,string_one,strlen(string_one)); 
	}
	else
	{
		write(gnuplot_pipe,"set xlabel\n", strlen("set xlabel\n"));
	}
	strcpy(string_one,fl_get_input(graph_ylabel_input));
	if(strlen(string_one) > 0)
	{
		write(gnuplot_pipe,"set ylabel \"", strlen("set ylabel \""));
		strcat(string_one,"\"\n");
		write(gnuplot_pipe,string_one,strlen(string_one)); 
	}
	else
	{
		write(gnuplot_pipe,"set ylabel\n", strlen("set ylabel\n"));
	}
	write(gnuplot_pipe,"plot ", strlen("plot "));
	for(i = 0; i < numbplot; i++)
	{
		if(line_style[toplot[i]] == 0)
		{
			sprintf(string_one,"'%s' using 1:%d title '%s' w points %d ", gnuplot_datafile_name,i + 2, data_matrix[toplot[i]].name,point_style[toplot[i]]);
			if(i != numbplot - 1) strcat(string_one,", ");
			write(gnuplot_pipe, string_one, strlen(string_one));
		}
		else
		{
			sprintf(string_one,"'%s' using 1:%d title '%s' w linespoints %d %d ", gnuplot_datafile_name,i + 2, data_matrix[toplot[i]].name, line_style[toplot[i]],point_style[toplot[i]]);
			if(i != numbplot - 1) strcat(string_one,", ");
			write(gnuplot_pipe, string_one, strlen(string_one));
		}  
	}
	write(gnuplot_pipe,"\n", strlen("\n"));
	strcpy(string_one,fl_get_input(graph_save_input));
	i = FALSE;
	if(strlen(string_one) > 0)
	{
		i = save_graph(string_one);
		if(i == TRUE) graph_output(string_one, xvar, toplot, numbplot);
	}
	if(i == FALSE) graph_output("", xvar, toplot, numbplot);
}

void hist_variables()
{
	int i,j;
	int xvar;
	float xcord, ycord, running, runningt, average, variance;
	float range, barwidth;
	char string_one[XLDLASMAX_INPUT];
	xvar = -1;
	for(i=0; i < numb_variables;i++)
	{
		if(fl_isselected_browser_line(xvar_browser, i+1))
		{
			xvar = i;
			i = numb_variables;
		}
	}
	if(xvar == -1)
	{
		fl_show_alert("No X variable selected","","",TRUE);
		return;
	}
	all_start = fl_get_counter_value(graph_from_counter);
	all_stop = fl_get_counter_value(graph_to_counter);
	if(all_stop > data_matrix[xvar].obs) all_stop = data_matrix[xvar].obs;
	
	if(all_stop < all_start)
	{
		fl_show_alert("From Value Greater than to Value!",
			      "",
			      "",
			      TRUE);
		return;
	}
	gnuplot_datafile = fopen(gnuplot_datafile_name,"w");
	worksize = 0;
	for(i = 0; i < all_stop - (all_start - 1); i++)
	{
		if(*(fvector[xvar] + i + (all_start - 1)) != missing_value)
		{
			working[worksize] = *(fvector[xvar] + i + (all_start -1));
			worksize++;
		}
	}	
	if(worksize == 0)
	{
		fl_show_alert("No Actual Observations in Range",
			      "",
			      "",
			      TRUE);
		return;
	}
	if(worksize < numb_bars)
	{
		fl_show_alert("Less Observations than Categories (Bars)",
			      "This is not a good way to summarize data!",
			      "Try reducing the number of bars or increasing the number of observations",
			      TRUE);
	}
	sort_working_vector();
	range = working[worksize - 1] - working[0];
	if(range == 0.0)
	{
		fl_show_alert("There's no Variation in this Data",
			  	"I can't draw a two-dimensional histogram using",
			  	"one dimension of data",
			  	TRUE);
		return;
	}
	barwidth = range / numb_bars;
	xcord = working[0];
	for(i = 0; i < numb_bars - 1; i++)
	{
		ycord = 0;
		for(j = 0;j < worksize; j++)
		{
			if(working[j] >= xcord && working[j] < xcord + barwidth) ycord ++;
		}
		fprintf(gnuplot_datafile,"%f  0.00\n", xcord);
		fprintf(gnuplot_datafile,"%f   %f\n", xcord, ycord / worksize);
		xcord = xcord + barwidth;
		fprintf(gnuplot_datafile,"%f   %f\n", xcord, ycord / worksize);
		fprintf(gnuplot_datafile,"%f  0.00\n",xcord);
	}
	ycord = 0;
	for(i = 0; i < worksize; i++)
	{
		if(working[i] >= xcord) ycord++;
	}
	fprintf(gnuplot_datafile,"%f  0.00\n", xcord);
	fprintf(gnuplot_datafile,"%f   %f\n", xcord, ycord / worksize);
	xcord = xcord + barwidth;
	fprintf(gnuplot_datafile,"%f   %f\n", xcord, ycord / worksize);
	fprintf(gnuplot_datafile,"%f  0.00\n",xcord);
	fclose(gnuplot_datafile);
	write(gnuplot_pipe,"set autoscale\n", strlen("set autoscale\n"));
	if(fl_get_button(graph_xrange_auto_button) != 1)
	{
		if(fl_get_counter_value(graph_xrange_from_counter) == fl_get_counter_value(graph_xrange_to_counter))
		{
			fl_set_counter_value(graph_xrange_to_counter, fl_get_counter_value(graph_xrange_from_counter) + 0.1);
		}	
		sprintf(string_one,"set xrange[%f:%f]\n", fl_get_counter_value(graph_xrange_from_counter), fl_get_counter_value(graph_xrange_to_counter));
		write(gnuplot_pipe, string_one, strlen(string_one));
	}
	if(graph_key_on == TRUE) write(gnuplot_pipe, "set key\n", strlen("set key\n"));
	else write(gnuplot_pipe, "set nokey\n", strlen("set nokey\n"));
	strcpy(string_one,fl_get_input(graph_title_input));
	if(strlen(string_one) > 0)
	{
		write(gnuplot_pipe,"set title \"", strlen("set title \""));
		strcat(string_one,"\"\n");
		write(gnuplot_pipe,string_one,strlen(string_one)); 
	}
	else
	{
		write(gnuplot_pipe,"set title\n", strlen("set title\n"));
	}
	strcpy(string_one,fl_get_input(graph_xlabel_input));
	if(strlen(string_one) > 0)
	{
		write(gnuplot_pipe,"set xlabel \"", strlen("set xlabel \""));
		strcat(string_one,"\"\n");
		write(gnuplot_pipe,string_one,strlen(string_one)); 
	}
	else
	{
		write(gnuplot_pipe,"set xlabel\n", strlen("set xlabel\n"));
	}
	strcpy(string_one,fl_get_input(graph_ylabel_input));
	if(strlen(string_one) > 0)
	{
		write(gnuplot_pipe,"set ylabel \"", strlen("set ylabel \""));
		strcat(string_one,"\"\n");
		write(gnuplot_pipe,string_one,strlen(string_one)); 
	}
	else
	{
		write(gnuplot_pipe,"set ylabel\n", strlen("set ylabel\n"));
	}
	if(graph_normal_on == FALSE)
	{
		sprintf(string_one,"plot '%s' title '%s' with lines\n", gnuplot_datafile_name, data_matrix[xvar].name);
		write(gnuplot_pipe,string_one, strlen(string_one));
	}
	else 
	{
		running = 0;
		runningt = 0;
		for(i = 0; i < worksize; i++)
		{
			running = running + working[i];
			runningt = runningt + (working[i] * working[i]);
		}
		average = running / worksize;
		variance = (runningt / worksize) - (average * average);
		
		sprintf(string_one,"plot '%s' title '%s' with lines, ((exp(-0.5 * (((x - %f) / sqrt(%f)) * ((x - %f) / sqrt(%f))))) / (sqrt(%f) * sqrt(6.2831853))) * %f title 'normal' \n", gnuplot_datafile_name, data_matrix[xvar].name, average,variance,average,variance,variance, (working[worksize - 1] - working[1]) / numb_bars);
		write(gnuplot_pipe,string_one,strlen(string_one));
	}
	strcpy(string_one,fl_get_input(graph_save_input));
	i = FALSE;
	if(strlen(string_one) > 0)
	{
		i = save_graph(string_one);
		if(i == TRUE) graph_output(string_one, xvar, 0, 0);
	}
	if(i == FALSE) graph_output("", xvar, 0, 0);
}

void plot_variables(FL_OBJECT *obj, long arg)
{
	if(fl_get_button(choose_plot_button) == TRUE)
	{
		graph_variables();
	}
	else
	{
		hist_variables();
	}
}




int click_done_graph_variables(FL_FORM *form, long arg)
{
	char string_one[XLDLASMAX_INPUT];
	write(gnuplot_pipe, "exit\n",strlen("exit\n"));
	close(gnuplot_pipe);
	wait(0);
	sprintf(string_one," rm %s &", gnuplot_datafile_name);
	do_system_call(string_one);
	say_status("Ready");
	window_geometry[XLDLAS_GRAPH][0] = form->x;
	window_geometry[XLDLAS_GRAPH][1] = form->y;
	window_geometry[XLDLAS_GRAPH][2] = form->w;
	window_geometry[XLDLAS_GRAPH][3] = form->h;
	reenable_graph_input();
	return(FL_OK);
}

void done_graph_variables(FL_OBJECT *obj, void *arg)
{
	char string_one[XLDLASMAX_INPUT];
	write(gnuplot_pipe, "exit\n",strlen("exit\n"));
	close(gnuplot_pipe);
	wait(0);
	sprintf(string_one," rm %s &", gnuplot_datafile_name);
	do_system_call(string_one);
	fl_hide_form(graph_window);
	window_geometry[XLDLAS_GRAPH][0] = obj->form->x;
	window_geometry[XLDLAS_GRAPH][1] = obj->form->y;
	window_geometry[XLDLAS_GRAPH][2] = obj->form->w;
	window_geometry[XLDLAS_GRAPH][3] = obj->form->h;
	say_status("Ready");
	reenable_graph_input();
}




void start_graph_variables(FL_OBJECT *obj, long arg)
{
	int i;
	int largest;
	inhibit_graph_input();
	say_status("Graphing Variables");
	fl_clear_browser(xvar_browser);
	fl_clear_browser(yvar_browser);
	largest = 0;
	for(i=0; i < numb_variables; i++)
	{
		if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
		fl_addto_browser(xvar_browser,data_matrix[i].name);
		fl_addto_browser(yvar_browser,data_matrix[i].name);
	}

	fl_set_counter_value(graph_from_counter, 1);
	fl_set_counter_bounds(graph_from_counter, 1, largest);
	fl_set_counter_step(graph_from_counter, 1, 10);

	fl_set_counter_value(graph_to_counter, largest);
	fl_set_counter_bounds(graph_to_counter, 1, largest);
	fl_set_counter_step(graph_to_counter, 1, 10);
	
	fl_set_counter_value(graph_bar_counter, numb_bars);
	fl_set_counter_bounds(graph_bar_counter, 1, XLDLAS_NUMB_BARS_MAX);
	fl_set_counter_step(graph_bar_counter, 1, 1);

	fl_set_button(choose_hist_button,0);
	fl_set_button(choose_plot_button,0);

	if(arg == 1)
	{
		fl_set_button(choose_hist_button,1);
	}
	else
	{
		fl_set_button(choose_plot_button,1);
	}

	fl_set_button(graph_key_button, 0);
	if(graph_key_on == TRUE)
	{
		fl_set_button(graph_key_button, 1);
	}
	
	fl_set_button(graph_overwrite_button, 0);
	if(graph_overwrite_on == TRUE)
	{
		fl_set_button(graph_overwrite_button, 1);
	}

	fl_set_button(graph_normal_button, 0);
	if(graph_normal_on == TRUE)
	{
		fl_set_button(graph_normal_button, 1);
	}
	
	
	fl_set_input(graph_format_input,graph_output_format);
	fl_set_input(graph_options_input,graph_output_options);
	for(i = 0; i < numb_variables; i++)
	{
		point_style[i] = 0;
		line_style[i] = (i % 6) + 1 ;
	}	
	gnuplot_pipe = launch_gnuplot();
	if(gnuplot_pipe >= 0)
	{
		if(window_geometry[XLDLAS_GRAPH][0] != -1)
		{
			fl_set_form_geometry(graph_window, 
						window_geometry[XLDLAS_GRAPH][0],
						window_geometry[XLDLAS_GRAPH][1],
						window_geometry[XLDLAS_GRAPH][2],
						window_geometry[XLDLAS_GRAPH][3]);
		}	
		fl_show_form(graph_window,FL_PLACE_FREE,FL_FULLBORDER,"Graph");
		do_logo_plot();
	}
	else
	{
		fl_show_alert("Hmmmm I can't seen to run gnuplot","Sorry, can't graph anything without it", "It's available at ftp://sunsite.unc.edu", TRUE);
		say_status("Ready");
		reenable_graph_input();
	}
}



void graph_routines(FL_OBJECT *menu, long user_data)
{
	int choice;
	choice = fl_get_menu(menu);
	if(choice == 1) start_graph_variables(menu, 1);
	if(choice == 2) start_graph_variables(menu, 2);
}


