%% ----------------------------------------------------------------------------
%% This file contains the source of the xdvipresent documentation (we simply 
%% take advantage of the lpdoc auto-documenter).
%% ----------------------------------------------------------------------------

:- use_package([assertions]).

:- comment(title,"Slide Presentations Using LaTeX/xdvi").

:- comment(author,"Manuel Hermenegildo").
:- comment(author,"@tt{herme@@fi.upm.es}").
:- comment(author,"CLIP Group").
:- comment(author,"School of Computer Science").
:- comment(author,"Technical University of Madrid").

:- comment(copyright,
	"Copyright @copyright{} Manuel Hermenegildo and The CLIP Group

	@include{Copyright.Manuals}
").

summary_fact("@apl{xdvipresent} provides glue for developing slides
              for on-line presentation using @apl{LaTeX} and
              @apl{xdvi}, and a (portable) computer with a sxga+
              (1400x1050), sxga (1280x1024), xga (1024x768), svga
              (800x600), vga (640x480), or sun (1152x900) screen
              running Xwindows.").

usage_message("For usage information type @tt{xdvipresent} with no
              arguments.").

:- comment(summary,"@includefact{summary_fact/1}").

:- comment(module,"

@includefact{summary_fact/1} The idea is that you prepare the slides
in LaTeX with the enclosed style file(s) and you use the
``@apl{xdvipresent}'' script (which simply calls @apl{xdvi} with an
appropriate set of options) to show the slides on the screen. The
package also provides tips on preparing presentations with @apl{xdvi},
for starting @apl{xdvipresent} from emacs, etc.

@section{Installation}

@subsection{Installation using (g)make} 

@begin{itemize}
@item Uncompress and untar the distribution in a suitable directory.

@item Set @tt{STYDIR} in Makefile to a place where LaTeX can find style files.

@item Set @tt{BINDIR} in Makefile to a place where executables can be
found.

@item Type @tt{gmake install}.

@item The @tt{doc} directory contains this manual in several formats
(postscript, emacs info, manl, ...). You should probably install them
in a public area.

@item Make sure you read the rest of this manual for important
instructions on how to prepare the presentations (and try out the
installation using the example provided)!

@end{itemize}

@noindent @bf{Note:} Depending on your system setup you may need to be
root to complete one or more of the steps above. 

@subsection{Manual installation}

If you find problems with the procedure above, you can perform the
installation as follows:

@begin{itemize}
@item Copy the files in the @tt{images} directory (.ps files to make the
  slides more appealing) to a place where LaTeX can find them.

@item Copy the class/style files (@tt{*.cls},@tt{*.sty}) to a place
  where LaTeX can find it (otherwise, put the whole path when using
  it).

@item Copy @tt{xdvipresent} to a place that is in your executable
  (bin) search path.

@item Type @tt{texhash} (this depends a bit on your LaTeX
  installation) so that LaTeX can find the new styles and files.

@item The @tt{doc} directory contains this manual in several formats
(postscript, emacs info, manl, ...). You should probably install them
in a public area.

@item Make sure you read the rest of this manual for important
instructions on how to prepare the presentations (and try out the
installation using the example provided)!  

@end{itemize}

@noindent @bf{Note:} Depending on your system you may need to be root
to complete one or more of the steps above.

@section{Preparing the slides}

Use the file @tt{example.tex} as a template. Observe how the front
matter, slide boundaries, headers and footers, etc. are set
up. Essentially:

@begin{itemize}

@item Use @tt{xdvislides} as the document class, using the type of
      display on which you will present. For example, use 

      @tt{\\documentclass[svga]@{xdvislides@}}

      @noindent if you plan to view the slides on an SVGA screen, and 

      @tt{\\documentclass[a4paper]@{xdvislides@}}

      @noindent if you plan to print them on A4 paper. There is also a
      special option, @tt{htmlslides}, which is intended for
      generating an HTML version of the slides using
      @apl{latex2html}. The idea is that simpler macros are used which
      do not confuse @apl{latex2html}. 

@item Nice headers and footers can be set: see the examples in
      @tt{example.tex}.

@item It is nice to use (possibly nested) item lists (@tt{\\itemize}),
      because the style typesets them in color.

@item Put each slide title inside @tt{\\subsection@{...@}}. This has the
      advantage that @tt{latex2html} creates a new HTML page for each
      slide.

@item The use of Helvetica fonts, which are very readable on a
      computer screen is highly recommended. With latex2e, simply add:
      @tt{\\fontfamily@{phv@} \\selectfont} just after
      @tt{\\begin@{document@}}, as in the @tt{example.tex} file.
      @end{itemize}


@section{Displaying slides on the screen}

Once installation is completed, you are ready to test the package.  To
test viewing on, for example, an svga screen:

@begin{itemize}

@item Edit @tt{example.tex} and comment in and out the right lines at
the beginning of @tt{example.tex} as appropriate for producing
svga-sized output.

@item If you use the @apl{emacs} editor, also move the uncommented
line to the top (this is so that AucTeX can see the format that you
have chosen --See @ref{Automating xdvi startup from emacs/AucTeX}).

@item Run LaTeX to generate the .dvi file for @tt{example.tex}.

@item (Make sure you are running Xwindows!)

@item Type: @tt{xdvipresent svga example.dvi}

@end{itemize}

@noindent This should start an @tt{xdvi} window containing the
slides. The @tt{xdvi} window should @em{cover the whole screen}, and
should have @em{no controls or sliders}, i.e., only the slides should
appear, and covering the whole screen. If this is not the case, this
is probably due to your window manager settings. Right ``out of the
box'' @apl{xdvipresent} works very well for example with @apl{fvwm} or
with the lightweight wondow managers that come with modern @apl{gnome}
desktops.  If you use @apl{fvwm} then simply add the line:

@tt{Style xdvi Notitle}

to your @file{.fvwmrc} file to ensure that the @apl{xdvi} window
started by @apl{xdvipresent} does not have a title bar (which would
take up precious display space). Otherwise, things should work right
away, unless you have set unusually wide borders for the windows.  If
you use other window managers then you may want to fine tune some
things (see later for explanations on how to do this).

@section{Printing the slides}

To print the slides, uncomment the appropriate line in the
@tt{example.tex} file (e.g., the one containing @tt{[a4paper]}), run
LaTeX again to generate the appropriate @tt{.dvi} file, and print
normally, using a command such as:

@tt{dvips -P <printer> example.dvi}

@noindent
Yo can use:

@tt{dvips -f < example.dvi > example.ps}

@noindent to generate a postscript file. Also, you can produce
@tt{pdf} output by coverting the @tt{ps} file with, e.g.,
@apl{ps2pdf}.

Selecting printing options, such as ``@tt{[a4paper]}'', produces
output in which the slides have a border. Note that this border looks
good on paper but would only take up precious screen space duing a
presentation.

@section{More details on what it does and why and some usage tips}

You may ask, why use @apl{xdvi} and not, e.g.,
@apl{ghostscript}/@apl{ghostview}?  I prefer @apl{xdvi} for a number
of reasons. First, @apl{xdvi} is soemwhat faster and seems to do
somewhat better dithering of the fonts on the screen, which means that
the text is more readable (although more recent versions of
@apl{ghostview} do a much better job). Also, @apl{xdvi} can be started
with no borders or buttons, which is more difficult to do with, e.g.,
@apl{ghostview}. Also, with @apl{xdvi} it is very easy and quick to
move forwards and backwards with the keyboard during the presentation.
The big drawback is that @apl{xdvi} does not show (at least at the
time time of writing this) text in color, such as that generated when
using the @tt{colordvi} package. Another alternative is to use
@tt{html} (perhaps generated with @apl{latex2html}, in order to be
able to have nice math notation) and a browser, but I find that it is
very difficult to produce consistent results with this approach.

You may also consider using more sophisticated tools like
@apl{prosper}. This is a tool developed after @apl{xdvipresent} and is
an improvement in many ways. It provides very nice styles but on the
other hand it almost requires that you generate @tt{pdf} every time
you want to see the slides, which results in a slower development
cycle. I tend to use @apl{xdvipresent} most of the time and
@apl{prosper} in some special cases, when addressing audiences used to
animated slides with transitions, etc.

Given the considerations above, and assuming that you buy the idea
that @apl{xdvi} is the way to go, there are two main problems that
this package solves:

@begin{itemize}

@item Giving the presentation a little color. As mentioned before, at
  the time of this writing @apl{xdvi} unfortunately does not
  understand color commands included in the LaTeX source (e.g., by
  using \\package@{colordvi@}). However, embedded postscript figures
  are rendered in color. This is used in the style definition to
  include some color in the presentation: a blue line between the
  slide title and the body, colored buttons as item bullets, and a red
  line to separate the footer. This is done in the @tt{*.cls/*.sty}
  style files. When printing on a B/W printer this is all really
  superfluous and a different style, which uses no color, is used. For
  printing on a color printer the slides prepared for on-line
  presentation can be used.

@item Forcing LaTeX and @apl{xdvi} to produce output in such a way that it fits
  exactly on the screen of a portable. This is solved by:

  @begin{itemize}

  @item Giving suitable page sizes and offsets to LaTeX, which is
    included in the @tt{xdvislides.cls} (and the older
    @tt{xdvi_slide.sty}) format. See @tt{example.tex} for a typical
    use. Note that some lines in the LaTeX file have to be commented
    out and others in depending on whether the file should be
    formatted for a vga screen, an svga screen, an xga screen, a
    printer, etc.

  @item Making @apl{xdvi} start with the right parameters, by using the
    @tt{xdvipresent} script instead of calling @apl{xdvi} directly. The idea
    is to make the image fit exactly in the screen and avoid the
    presence of side bars, buttons, etc. The script takes at least two
    arguments. The first argument must be @tt{vga}, @tt{svga},
    @tt{a4paper}, etc., depending on the display to be used (entries
    such as @tt{a4paper} mean view the slides as they will be
    printed). The second argument must be the .dvi file name
    (including the suffix). Any other arguments are passed directly to
    @apl{xdvi}. Here are some possibilities: 

    @begin{description}

        @item{-bg <color>} 

        to change the color of the background (but note that white
        (the default) is often best for low-contrast displays)

        @item{-fg <color>}

        to change the color of the foreground (text, etc.)

        @item{-geometry <xsize>x<ysize>+<xoffset>+<yoffset>}

        the default values are, for example, ``630x470+0+0'' for vga
        (640x480 screen) and ``790x590+0+0'' for svga (800x600 screen)
        Note that 10 points are left for the window border, whose
        standard size is 5pt on each side under @apl{fvwm} (this may
        need adjustment for other window managers). It is also assumed
        that the @apl{xdvi} window does not have a title bar (which
        would take up precious display space). In order to ensure this
        in @apl{fvwm}, add the line

        @tt{Style xdvi Notitle}

        to your @file{.fvwmrc} (similar commands should be available
        in other window managers). If your setting is different from
        that assumed, you may have to tweak these values a bit.

        In @apl{fvwm} and other window managers that support several
        working spaces it is sometimes useful to display the slides in
        another ``page'' of the display. This can be done by adding
        offsets (which will be applied >from the page in which the
        @apl{xdvi} is started). E.g., @tt{-geometry 790x590+0+1024}
        will start the @apl{xdvi} in the screen below the current one
        in a standard X86Free 1280x1024 virtual display.

        @item{-display <displayname>}

        Useful for running LaTeX on one machine but showing the slides
        on another (e.g., @tt{-display <machine_name>:0.0}).

        @end{description}
    
    (see the @apl{xdvi} documentation for more details on options). 

  @end{itemize}

@end{itemize}

@section{Automating xdvi startup from emacs/AucTeX}

If you are using AucTeX and @apl{emacs}, then by putting some
additional lines in the @tt{tex-site.el} file it is possible to make
@apl{emacs} automatically invoke @apl{xdvipresent} with the right
parameters when doing @tt{C-c C-c View} or @tt{C-c C-c Print}.  The
selection will be based automatically on the presentation option (vga,
svga, xga, sun, svga, svga+, a4paper, letterpaper, ...) that you are
using in the @tt{documentclass} line in the latex file. Note that if
you change this you will have to delete the buffer and open the file
again for @apl{emacs} to notice the changes. Also note that, if
another, commented out @tt{documentclass} line appears in the file
before the one being used, then the commented one may be one seen by
@apl{emacs} instead. Thus, it is best to keep the @em{active}
@tt{documentclass} line the first one in the file.

These are examples of the entries that you may want to add to the
@tt{tex-site.el} file:

@begin{verbatim}
(defvar TeX-view-style '(
    ;; xdvipresent entries
    (\"^sxga\\+\" \"xdvipresent sxga+ %d\")
    (\"^sxga$\" \"xdvipresent sxga %d\")
    (\"^sun$\" \"xdvipresent sun %d\")
    (\"^xga$\" \"xdvipresent xga %d\")
    (\"^svga$\" \"xdvipresent svga %d\")
    (\"^vga$\" \"xdvipresent vga %d\")
    (\"^a4paper$\" \"xdvipresent a4paper %d\")
    (\"^letterpaper$\" \"xdvipresent letterpaper %d\")
    ;;
    (\"^landscape$\" \"xdvi %d -paper a4r -s 4\")
    (\"^a5$\" \"xdvi %d -paper a5\")
    (\".\" \"xdvi %d -s 7 -hushspecials -hl green -bd red -cr blue
         -expert -paper a4 -geometry -0+0\")
    )
@end{verbatim}

@noindent (Note that if you are indeed an emacs/AucTex user you could
also simply copy the @apl{xdvi} commands with the right parameters
from the @apl{xdvipresent} script into this file and not use the
@apl{xdvipresent} script at all!)

In a portable, and running a window manager that supports several work
surfaces, such as @apl{fvwm}, it is convenient to start the @apl{xdvi}
in an adjacent work surface. These are examples:

@begin{verbatim}
(defvar TeX-view-style '(
    ;; xdvipresent entries
    (\"^sxga\\+\" \"xdvipresent sxga+ %d -geometry 1390x1040+0+1050\")
    (\"^sxga$\" \"xdvipresent sxga %d -geometry 1270x1014+0+1024\")
    (\"^sun$\" \"xdvipresent sun %d -geometry 1142x890+0+900\")
    (\"^xga$\" \"xdvipresent xga %d -geometry 1014x758+0+768\")
    (\"^svga$\" \"xdvipresent svga %d -geometry 790x590+0+1024\")
    (\"^vga$\" \"xdvipresent vga %d -geometry 630x470+0+800\")
    (\"^a4paper$\" \"xdvipresent a4paper %d\")
    (\"^letterpaper$\" \"xdvipresent letterpaper %d\")
    ;;
    (\"^landscape$\" \"xdvi %d -paper a4r -s 4\")
    (\"^a5$\" \"xdvi %d -paper a5\")
    (\".\" \"xdvi %d -s 7 -hushspecials -hl green -bd red -cr blue
          -expert -paper a4 -geometry -0+0\")
    )
@end{verbatim}

In your @tt{.emacs} file you should put something like:

@begin{verbatim}
  ;; Auc-TeX
  (setq load-path (cons \"....../auctex-9.6\" load-path))
  (load \"tex-site\")
  (setq-default TeX-parse-self t) ;; Forces parsing of options in file!
@end{verbatim}

").

%% --------------------------------------------------------------------------

%% To avoid being documented as a library.
main.

%% --------------------------------------------------------------------------

:- comment(version_maintenance,dir('version')).

:- comment(version(0*6+14,2003/03/01,18:48*18+'CET'), "Now color
   bullet items appear correctly when using babel options that
   redefine them (such as Spanish).  (Manuel Hermenegildo)").

:- comment(version(0*6+13,2003/03/01,16:23*59+'CET'), "sxga
   (1280x1024) and sxga+ (1400x1050) screens now supported.  Prosper
   now mentioned in manual. (Manuel Hermenegildo)").

:- comment(version(0*6+12,1999/11/11,12:31*46+'MET'), "Fixed minor bug
   with recent versions of xdvi: -hushspecials (still in
   documentation) does not work any more.  (Manuel Hermenegildo)").

:- comment(version(0*6+11,1999/09/29,12:25*19+'MEST'), "Fixed yet
   another minor installation problem (dist dir not used now in
   installation).  (Manuel Hermenegildo)").

:- comment(version(0*6+10,1999/09/28,11:52*28+'MEST'), "Improved
   documentation a bit.  (Manuel Hermenegildo)").

:- comment(version(0*6+9,1999/09/28,10:57*50+'MEST'), "Improved
   installation procedure.  (Manuel Hermenegildo)").

:- comment(version(0*6+8,1999/04/28,13:49*20+'MEST'), "Minor changes
   to installation.  (Manuel Hermenegildo)").

:- comment(version(0*6+7,1999/02/19,08:59*42+'MET'), "Added sun option
   (1152x900).  (Manuel Hermenegildo)").

:- comment(version(0*6+6,1999/02/15,19:38*41+'MET'), "Updated
   distribution scripts.  (Manuel Hermenegildo)").

:- comment(version(0*6+5,1999/02/15,18:40*30+'MET'), "Improved the
   documentation somewhat.  (Manuel Hermenegildo)").

:- comment(version(0*6+4,1999/02/15,17:15*18+'MET'), "Added xga
   option (1024x768).  (Manuel Hermenegildo)").

:- comment(version(0*6+3,1999/02/15,17:14*16+'MET'), "Offsets now set
   in style file instead of using xdvi options (since the -offset
   option does not seem to work in newer versions of Linux xdvi).
   (Manuel Hermenegildo)").

:- comment(version(0*6+2,1998/11/18,10:50*22+'MET'), "Fixed
   installation instructions (they were outdated).  (Manuel
   Hermenegildo)").

:- comment(version(0*6+1,1998/11/06,18:56*46+'MET'), "Added htmlslides
   option for easier generation of html slides using latex2html
   (changes by Manuel Carro).  (Manuel Hermenegildo)").

:- comment(version(0*6+0,1998/08/13,18:14*45+'MET DST'), "Modified for
   standard installation.  (Manuel Hermenegildo)").

%% --------------------------------------------------------------------------
