/*
 *	xcdroast.h
 *	21.10.02 tn@xcdroast.org
 *
 *
 *  Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.
 *
 *  This file is part of xcdroast.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include <cairo.h>

#define XCDROAST_VERSION VERSION 
#define MAXLINE 1024
#define CDDAFRAME 2352
#define DATASECTORSIZE 2048
#define SUNDATASECTORSIZE 512
#define XCDRLOGO "icons/xcdrlogo.png"
#define XCDRLOGO_MIDDLE "icons/xcdrlogo_middle.png"
#define XCDRLOGO_SMALL "icons/xcdrlogo_small.png"
#define XCDRLOGO_ICON "icons/xcdrlogo_icon.png"
#define CDDBLOGO "icons/cddblogo.png"
#define IMG_EXTENSIONS { ".iso", ".raw", ".img", ".wav", ".toc", NULL }
#define CDR_TYPES_MIN { 21, 23, 74, -80, 90, 99, 100, 0 } /* negative value is default */
#define DVD_TYPES_MB { 1460, 2660, 4700, 8540, 0 } /* DVD sizes are declared with decimal prefix */
#define CHARSET_CONVERT_FROM "iso8859-1"	/* CD-Text and default CDDB charset */
#define TMP_XCDR_DIR "/tmp"
#define XCDROAST_INFO_EXT ".xinf"
#define CDDA2WAV_INFO_EXT ".inf"
#define DISPLAY_SIDEBAR_LOGO TRUE
#define DELETE_BLOCKS 50

/*
 * which is base of all filetree-selectors? Set to "$HOME" to have
 * this automatically be the home-directory of the current user
 *
 * #define FILETREEBASE "$HOME" *** currently not used! ***
 */
#define FILETREEBASE "/"

/*
 * texts for the write modes
 */
#define WRITE_MODES { \
	N_("Disc-At-Once (DAO)"), \
	N_("Track-At-Once (TAO)"), \
	N_("TAO with zero pregap"), \
	N_("RAW writing (raw96r)"), \
	N_("RAW writing (raw96p)"), \
	N_("RAW writing (raw16)"), \
	NULL }

#define HELP_WRITE_MODES { \
	N_("Writes a CD in Disc-At-Once mode. This will create an exact copy without any pauses between the tracks. This mode may not work with old CD writers."), \
	N_("Writes a CD in Track-At-Once mode. Generates a 2 second pause between each track, but is supported on all writers."), \
	N_("Writes a CD in Track-At-Once mode, but eliminates the 2 second pause. This looks very much like DAO, but only works with the following drives: Teac CD-R50S, Teac CD-R55S, JVC XR-W2010, Pinnacle RCD-5020."), \
	N_("Writes a CD in RAW writing mode. It will write with 2352 byte sectors plus 96 bytes of raw P-W subchannel data resulting in a sector size of 2448 bytes. This is the preferred raw writing mode as it gives best control over the CD writing process."), \
	N_("Writes a CD in RAW writing mode. It will write with 2352 byte sectors plus 96 bytes of packed P-W subchannel data resulting in a sector size of 2448 bytes. This is the less preferred raw writing mode as only a few recordes support it."), \
	N_("Writes a CD in RAW writing mode. It will write with 2352 byte sectors plus 16 bytes of P-Q subchannel data resulting in a sector size of 2368 bytes. If a recorder does not support raw96r, this is the preferred raw writing mode. It does not allow to write CD-Text but it is the only raw writing mode in cheap CD writers. As these cheap writers in most cases do not support DAO mode."), \
	NULL }

/*
 * texts for the blank modes -
 * They are hard coded in cdrecord and must not be changed here!
 * We only provide them for the purpose of translation.
 */
#define BLANK_MODES { \
	N_("blank the entire disk"), \
	N_("minimally blank the entire disk (PMA, TOC, pregap)"), \
	N_("blank a track"), \
	N_("unreserve a track"), \
	N_("blank a track tail"), \
	N_("unclose last session"), \
	N_("blank last session"), \
	NULL }

/*
 * texts for the view modes
 */
#define VIEW_MODES { \
	N_("Small"), \
	N_("Normal"), \
	N_("Extended"), \
	NULL }

/*
 * texts for the "right click"
 * context menu in "Master Tracks"
 */
#define CONTEXT_MSTRMENU { \
	N_("Select all"), \
	N_("Unselect all"), \
	N_("Load list"), \
	N_("Save list"), \
	N_("Clear list"), \
	NULL }

/*
 * icons for dialogs (borrowed from GNOME)
 */
#define ICO_ERROR "icons/dialog_error.png"
#define ICO_INFO "icons/dialog_information.png"
#define ICO_WARN "icons/dialog_warning.png"
#define ICO_QUEST "icons/dialog_question.png"
#define ICO_DEF "icons/dialog_default.png"

/*
 * external called programms
 */
#ifndef hpux
# define DF "/bin/df -k" 
# define DF2 "/usr/bin/df -k" 
#else
# define DF "/bin/df -b" 
# define DF2 "/usr/bin/df -b" 
#endif
#define UNAME "/bin/uname -a"
#define UNAME2 "/usr/bin/uname -a"

#define CHOWNGRPMOD_PATH "/bin:/usr/bin:/sbin:/usr/sbin"
#define CHOWN "chown"
#define CHGRP "chgrp"
#define CHMOD "chmod"

#define WAVPLAY "bin/wavplay"
#define RMTOOL "bin/rmtool"
#define VRFYTOOL "bin/vrfytool"
#define CDDBTOOL "bin/cddbtool"
#define WRAPPER "bin/xcdrwrap"

/*
 * this paths can be specified relative to lib-dir or absolute
 * xcdroast will look for these first in $LIBDIR/ and if not found
 * then in $PREFIX (e.g. /usr/bin/cdrecord instead of 
 * /usr/local/lib/xcdroast/bin/cdrecord)
 */
#define CDRECORD "bin/cdrecord" 
#define CDDA2WAV "bin/cdda2wav"
#define READCD "bin/readcd"
#define MKISOFS "bin/mkisofs"

/*
 * MINIMUM required versions. Greater versions are now silently
 * accepted. 
 * Distribution-Vendors: DO NOT TOUCH THESE!
 * IT WON'T WORK WITH LOWER VERSIONS, EVEN WHEN YOU THINK IT DOES!
 */
#define CDRECORD_VERSION "3.02a09"
#define MKISOFS_VERSION "3.02a09"
#define CDDA2WAV_VERSION "3.02a09"
#define READCD_VERSION "3.02a09"

/*
 * Tool to set the wrapper suid bit
 */
#define GKSUDO_BINARY "/usr/bin/gksudo"
#define SUDO_BINARY "/usr/bin/sudo"

#define DSPTESTSOUND "sound/test.wav"	/* demo sound */

#define MAXDEVICES 128		/* max scanned scsi devices */

#define MAXDRIVERS 64		/* max support for cdrecord-drivers (as in cdrecord driver=help) */ 

#define MAXBLANKMODES 16	/* max support for blank-modes (as in cdrecord blank=help) */

#define MAXCHARSETS 64		/* max support for joliet charsets */

#define MAXTRACKS 100		/* max tracks a CD can have */

#define MAXCDDB 100		/* max CDDB matches */

#define MAXPIPEARGS 1024	/* max args for pipes */

#define NETIOTIMEOUT 10;	/* timeout in seconds for CDDB queries over network */

#define IMGFILEPREFIX "track"	/* default image-file-prefix */

/*
 * default filenames for process-output-savefiles
 */
#define SAVEOUTCDRECORD "cdrecord.out"
#define SAVEREADTRACKS "readtracks.out"
#define SAVEVERIFYTRACKS "verifytracks.out"
#define SAVEMASTERTRACK "mkisofs.out"
#define SAVEMASTERCALC "mkisofscalc.out"
#define SAVEMASTERLIST "xcdrmaster.lst"

/*
 * default paths / config files
 */
#define PREFIX "/usr/local"
#define LIBDIR "lib/xcdroast"
#define CONFIGDIR "~/.config/xcdroast"
#define CONFFILE "xcdroast.cfg"
#define LOGFILE "xcdroast.log"
#define ISOOPTFILE "isoopt.cfg"
#define ISOHEADERFILE "isoheader.cfg"
#define WRITEOPTFILE "writeopt.cfg"

/*
 * rootconfig is stored in $sysconfdir (/usr/local/etc by default)
 */
#define ROOTCONFIG "xcdroast.conf"

/*
 * font definitions
 */
#define PANGO_MONOSPACE "Monospace 10"
#define PANGO_BOLD "Normal Bold"
#define PANGO_BIG "Normal 18"
#define PANGO_ITALIC "Italic"

/*
 * default window sizes - usage autodetected
 */
#define XCDR_TOPLEVEL_X0 790	/* 75dpi fonts */
#define XCDR_TOPLEVEL_Y0 550

#define XCDR_TOPLEVEL_X1 1010	/* 100dpi fonts */
#define XCDR_TOPLEVEL_Y1 670

/*
 * file selector modes
 */
#define MODE_OPEN 0
#define MODE_SAVE 1

/*
 * used to enable/disable labels
 */
#define ENABLEDCOLOR "enabled"
#define DISABLEDCOLOR "disabled"
#define SELECTEDCLISTCOL "gray70"

/*
 * text shortcuts
 */
#define T_XCDROAST "X-CD-Roast"
#define T_YES _("Yes") 
#define T_NO _("No") 
#define T_CANCEL _("Cancel") 
#define T_OK _("Ok") 
#define T_CLOSE _("Close") 
#define T_ANYWAY _("Continue anyway")
#define T_EXIT _("Exit")

/*
 * predefined master iso-opitions
 * there must be the same number of TYPES as TEXTS (minus the NULL element)
 */
#define MASTER_TEXTS { \
	N_("Rock Ridge + Joliet"), \
	N_("Rock Ridge only"), \
	N_("MS-DOS"), \
	NULL }
#define MASTER_TYPES { 	{ 1,1,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }, \
			{ 1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }, \
			{ 0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } }

#define DEF_BOOT_CATALOG "boot.catalog"

/*
 * some defines for drag&drop
 */
#define DRAG_TAR_NAME_0         "text/plain"
#define DRAG_TAR_INFO_0         0
#define DRAG_TAR_NAME_1         "text/uri-list"
#define DRAG_TAR_INFO_1         1
#define DRAG_TAR_NAME_2         "STRING"
#define DRAG_TAR_INFO_2         2

/*
 * long long format
 */
#if __x86_64 || __ppc64 || __sparc64
#  define LL_FORMAT "ld"
#else
#  define LL_FORMAT "lld"
#endif
