/* +-------------------------------------------------------------------+ */
/* | Copyright 1992, 1993, David Koblas (koblas@netcom.com)            | */
/* | Copyright 1995, 1996 Torsten Martinsen (bullestock@dk-online.dk)  | */
/* |                                                                   | */
/* | Permission to use, copy, modify, and to distribute this software  | */
/* | and its documentation for any purpose is hereby granted without   | */
/* | fee, provided that the above copyright notice appear in all       | */
/* | copies and that both that copyright notice and this permission    | */
/* | notice appear in supporting documentation.  There is no           | */
/* | representations about the suitability of this software for        | */
/* | any purpose.  this software is provided "as is" without express   | */
/* | or implied warranty.                                              | */
/* |                                                                   | */
/* +-------------------------------------------------------------------+ */

/* $Id: main.c,v 1.16 1997/09/03 19:31:07 torsten Exp $ */

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#ifndef NOSTDHDRS
#include <stdlib.h>
#include <unistd.h>
#endif

#include <xpm.h>

#define DEFINE_GLOBAL
#include "xpaint.h"
#include "Paint.h"
#include "misc.h"
#include "operation.h"
#include "graphic.h"
#include "protocol.h"
#include "rw/rwTable.h"

#include "xartIcon.xpm"

extern void BrushInit(Widget toplevel);

static char *appDefaults[] =
{
#include "xart.ad.h"
    NULL
};

gcFunction = 3;

typedef struct {
    String visualType;
    String size;
    String help;
    String rcFile;
    Boolean popped;
    Boolean nowarn;
} AppInfo;

static AppInfo appInfo;

static XtResource resources[] =
{
    {"visualType", "VisualType", XtRString, sizeof(String),
   XtOffset(AppInfo *, visualType), XtRImmediate, (XtPointer) "default"},
    {"size", "Size", XtRString, sizeof(String),
     XtOffset(AppInfo *, size), XtRImmediate, (XtPointer) "300x200"},
    {"rcFile", "RcFile", XtRString, sizeof(String),
     XtOffset(AppInfo *, rcFile), XtRImmediate, (XtPointer) NULL},
    {"help", "Help", XtRString, sizeof(String),
     XtOffset(AppInfo *, help), XtRImmediate, (XtPointer) NULL},
    {"popped", "Popped", XtRBoolean, sizeof(Boolean),
     XtOffset(AppInfo *, popped), XtRImmediate, (XtPointer) False},
    {"nowarn", "NoWarn", XtRBoolean, sizeof(Boolean),
     XtOffset(AppInfo *, nowarn), XtRImmediate, (XtPointer) False},
};

static XrmOptionDescRec options[] =
{
    {"-24", ".visualType", XrmoptionNoArg, (XtPointer) "true24"},
    {"-12", ".visualType", XrmoptionNoArg, (XtPointer) "cmap12"},
    {"-size", ".size", XrmoptionSepArg, (XtPointer) NULL},
    {"-rcFile", ".rcFile", XrmoptionSepArg, (XtPointer) NULL},
    {"-popped", ".popped", XrmoptionNoArg, (XtPointer) "True"},
    {"-nowarn", ".nowarn", XrmoptionNoArg, (XtPointer) "True"},
    {"-help", ".help", XrmoptionNoArg, (XtPointer) "command"},
    {"+help", ".help", XrmoptionSepArg, (XtPointer) NULL},
    {"-8", ".visualType", XrmoptionNoArg, (XtPointer) "cmap8"},
    {"-visual", ".visualType", XrmoptionSepArg, (XtPointer) NULL},
};


/*
**  Public query functions for application defaults
 */

void 
GetDefaultWH(int *w, int *h)
{
    int x, y;
    unsigned int width, height;

    XParseGeometry(appInfo.size, &x, &y, &width, &height);
    *w = width;
    *h = height;
}

char *
GetDefaultRC(void)
{
    return appInfo.rcFile;
}

/*
**  Create a nice icon image for XPaint...
 */
void 
SetIconImage(Widget w)
{
    static Pixmap icon = None;
    static int iconW = 1, iconH = 1;
    Window iconWindow;
    Screen *screen = XtScreen(w);
    Display *dpy = XtDisplay(w);
    XpmAttributes myattributes;

    /*
    **  Build the XPaint icon
     */
    iconWindow = XCreateSimpleWindow(dpy, RootWindowOfScreen(screen),
				     0, 0,	/* x, y */
				     iconW, iconH, 0,
				     BlackPixelOfScreen(screen),
				     BlackPixelOfScreen(screen));
    if (icon == None) {
 	myattributes.valuemask = XpmCloseness;
 	myattributes.closeness = 65535;
 	if (XpmCreatePixmapFromData(dpy, iconWindow,
				    xartIcon_xpm, &icon, NULL, &myattributes)) {
	    fprintf(stderr, "Cannot install XPM icon\n");
	    exit(1);
 	}
	GetPixmapWHD(dpy, icon, &iconW, &iconH, NULL);
	XResizeWindow(dpy, iconWindow, iconW, iconH);
    }
    XSetWindowBackgroundPixmap(dpy, iconWindow, icon);

    XtVaSetValues(w, XtNiconWindow, iconWindow, NULL);
}


/*
**  The rest of main
 */
static void 
usage(char *prog, char *msg)
{
    if (msg)
	fprintf(stderr, "%s\n", msg);
    fprintf(stderr, "Usage for %s (xart %s):\n", prog, XPAINT_VERSION);
    HelpTextOutput(stderr, appInfo.help == NULL ? "command" : appInfo.help);
    exit(1);
}

typedef struct {
    XtWorkProcId id;
    Widget toplevel;
    int nfiles;
    int pos;
    char **files;
} LocalInfo;

static Boolean
workProc(LocalInfo * l)
{
    char *file;
    void *v;

    if ((l == NULL) || (l->id == None))
	return TRUE;

    file = l->files[l->pos];

    StateSetBusy(True);

    if ((v = ReadMagic(file)) != NULL)
	GraphicOpenFile(l->toplevel, file, v);
    else
	Notice(l->toplevel, "Unable to open input file \"%s\"\n	%s",
	       file, RWGetMsg());

    StateSetBusy(False);

    if (++l->pos == l->nfiles) {
	XtFree((XtPointer) l->files);
	XtFree((XtPointer) l);
	return TRUE;
    } else
	return FALSE;
}

/*
 * You can specify:
 * the visual
 * the visual and the depth
 * the visualID
 * Any other combinations may not generate the results that you expect
 * Also note that the visualID is strongly dependent on the platform
 * being used.  We will let the user specify any visualID that they want.
 */
XVisualInfo
GetFutureVisual(Widget *toplevel, int desiredDepth, int desiredVisual,
		int desiredVisualID, Boolean *valid)
{
    Display *display = XtDisplay(*toplevel);
    int i, visnum = 0;
	
    XVisualInfo rtnval;
	
    int visualsMatched;    
     
    XVisualInfo vTemplate;   
    XVisualInfo visual[50]; /* If a machine has more than 50 visuals then this will fail. Higher end SGI's have 20 so this is probably OK */
    XVisualInfo *visualList = visual;
	

    *valid=FALSE;
      
    vTemplate.screen = DefaultScreen(display);

    if (desiredVisualID >= 0)
        visualList = XGetVisualInfo (display, VisualScreenMask, &vTemplate, &visualsMatched);
    else {
        vTemplate.class = desiredVisual;
	if (desiredDepth > 0) {
	    vTemplate.depth = desiredDepth;
	    visualList = XGetVisualInfo(display,
					VisualClassMask | VisualScreenMask |
					VisualDepthMask, &vTemplate,
					&visualsMatched);
	}
	else {
  	    visualList = XGetVisualInfo(display,
					VisualClassMask | VisualScreenMask,
					&vTemplate, &visualsMatched);
	}
    }

    if (visualsMatched && desiredVisualID >= 0) {
        visnum = -1;
	/* look through the entire list for our visual ID */
	for (i = 0; i < visualsMatched; i++) {
  	    if (XVisualIDFromVisual(visualList[i].visual) == desiredVisualID)
	        visnum = i;
	}
	if (visnum < 0)
	    visualsMatched=0;
    }
	
    if (visualsMatched == 0) {
        fprintf(stderr, "No match found for visual\n");
	exit(1);
    }
	
    rtnval = visualList[visnum];
    *valid = TRUE;
	  
    XFree(visualList);
	
    return rtnval;
}


void 
main(int argc, char *argv[])
{
    Display *dpy;
    Widget toplevel;
    XtAppContext app;
    char xpTitle[20];
    int i;
    XEvent event;
    Arg args[5];
    int nargs = 0;
    XrmDatabase rdb;
    Boolean isIcon;

    Widget temp;
    int desiredVisual = -1;
    XVisualInfo vis;
    Boolean valid;
    int depth;
    int desiredDepth;
    int tempargc;
    char tempargvMem[5][1024];
    char *tempargv[5];
    char phrase[128];
    int desiredVisualID = -1;	 

    InitTypeConverters();
	 
    /*
     * Create a temp widget that we can interrogate.
     * This widget will not be realized. 
     * There should be a better way to do this...
     */
    tempargc = argc;
    for (i = 0; i < tempargc; i++) {
        tempargv[i] = tempargvMem[i];
	strcpy(tempargv[i], argv[i]);
    }
    temp = XtAppInitialize(&Global.appContext, "XPaint",
			   options, XtNumber(options), &tempargc, tempargv,
			   appDefaults, args, nargs);
    XtGetApplicationResources(temp, (XtPointer) & appInfo,
			      resources, XtNumber(resources), NULL, 0);
    rdb = XtDatabase(XtDisplay(temp));
	 
    if (appInfo.help != NULL)
	usage(argv[0], NULL);

    desiredDepth = 0;
    if (strcmp(appInfo.visualType, "default") != 0) {
        char *cp = appInfo.visualType;
	char *vp = phrase;

	/* this includes the terminating null character */
	for (i = 0; i <= strlen(cp); i++)
	    phrase[i] = tolower(cp[i]);
		 
	if (strncmp(vp, "cmap", 4) == 0) {
	    XrmPutStringResource(&rdb, "Canvas*visual", "PseudoColor");
	    desiredVisual = PseudoColor;
	    vp += 4;
	} else if (strncmp(vp, "directcolor", 11) == 0) {
	    XrmPutStringResource(&rdb, "Canvas*visual", "DirectColor");
	    desiredVisual = DirectColor;
	    desiredDepth = 24;
	    vp += 11;
	} else if (strncmp(vp, "truecolor", 9) == 0) {
	    XrmPutStringResource(&rdb, "Canvas*visual", "TrueColor");
	    desiredVisual = TrueColor;
	    desiredDepth = 24;
	    vp += 9;
	} else if (strncmp(vp, "grayscale", 9) == 0) {
	    XrmPutStringResource(&rdb, "Canvas*visual", "GrayScale");
	    desiredVisual = GrayScale;
	    desiredDepth = 8;
	    vp += 9;
	} else if (strncmp(vp, "pseudocolor", 11) == 0) {
	    XrmPutStringResource(&rdb, "Canvas*visual", "PseudoColor");
	    desiredVisual = PseudoColor;
	    vp += 11;
	} else if (strncmp(vp, "staticgray", 10) == 0) {
	    XrmPutStringResource(&rdb, "Canvas*visual", "StaticGray");
	    desiredVisual = StaticGray;
	    desiredDepth = 8;
	    vp += 10;
	} else if (strncmp(vp, "staticcolor", 11) == 0) {
	    XrmPutStringResource(&rdb, "Canvas*visual", "StaticColor");
	    desiredVisual = StaticColor;
	    desiredDepth = 8;
	    vp += 11;
	} else if (strncmp(vp, "true", 4) == 0) {
	    XrmPutStringResource(&rdb, "Canvas*visual", "TrueColor");
	    desiredVisual = TrueColor;
	    vp += 4;
	} else if (strncmp(vp, "gray", 4) == 0) {
	    XrmPutStringResource(&rdb, "Canvas*visual", "StaticGray");
	    desiredVisual = StaticGray;
	    vp += 4;
	} else if (atoi(vp)>0 || (vp[0]=='0' && vp[1]=='\0')) {
 	    desiredVisualID = atoi(vp);
	    *vp = '\0';
	} else {
	    fprintf(stderr, "%s: bad visual type specification '%s'\n",
		    argv[0], vp);
	    exit(1);
	}
	if (*vp != '\0') {
	    desiredDepth=atoi(vp);
	    if (desiredDepth > 0) 
	        XrmPutStringResource(&rdb, "Canvas*depth", vp);
	    else
	        desiredDepth = 0;
	}
    }
    else {
        /* go find out what the default visual is and get its parameters */
        Global.vis.depth = DefaultDepth(XtDisplay(temp),
					DefaultScreen(XtDisplay(temp)));
	Global.vis.visual = DefaultVisual(XtDisplay(temp),
					  DefaultScreen(XtDisplay(temp)));
    }

    if (desiredVisual >= 0 || desiredVisualID >= 0) {
        vis = GetFutureVisual(&temp, desiredDepth,
			      desiredVisual, desiredVisualID, &valid);
		 
	if (valid) {
	    depth = vis.depth;
	    Global.vis = vis;
	}
	else {
	    fprintf(stderr, "No match found for visual\n");
	    exit(1);
	}
    }
    else {
        Global.vis.depth = DefaultDepth(XtDisplay(temp),
					DefaultScreen(XtDisplay(temp)));
	Global.vis.visual = DefaultVisual(XtDisplay(temp),
					  DefaultScreen(XtDisplay(temp)));
    }
	 
    sprintf(phrase, "%d", Global.vis.depth);
    XrmPutStringResource(&rdb, "Canvas*depth", phrase);

    /* destroy our temporary widget */
    XtDestroyWidget(temp);
	 
    /*
    **  Create the application context
     */

    toplevel = XtAppInitialize(&Global.appContext, "XPaint",
			       options, XtNumber(options), &argc, argv,
			       appDefaults, args, nargs);

    XtGetApplicationResources(toplevel, (XtPointer) & appInfo,
			      resources, XtNumber(resources), NULL, 0);

	 
	 
    if (argc != 1 && argv[1][0] == '-')
	usage(argv[0], "Invalid option");
	 
    /*
    **  A little initialization
     */
    Global.region.image = NULL;
    Global.region.cmap = None;
    Global.region.width = 0;
    Global.region.height = 0;
    Global.region.pix = None;
    Global.region.mask = None;

    /*
    **
     */
    XtVaGetValues(toplevel, XtNiconic, &isIcon, NULL);
    if (isIcon)
	XrmPutStringResource(&rdb, "Canvas.iconic", "on");

	 
    /*
    **  GRR 960525:  check depth and warn user (use AlertBox() instead?)
     */
    if (!appInfo.nowarn) {
	int depth = Global.vis.depth;

	/* XtVaGetValues(toplevel, XtNdepth, &depth, NULL); */
	HelpTextOutput(stderr, "data_loss");
	fprintf(stderr, "\nYour canvas depth is %d bits.\n\n", depth);
	switch (depth) {
	    case 8:
	    case 12:
		fprintf(stderr, "     =============================================================\n");
		fprintf(stderr, "     WARNING!  Most true-color images will suffer major data loss!\n");
		fprintf(stderr, "     =============================================================\n");
		fprintf(stderr, "\n");
		break;
	    case 1:
	    case 2:
	    case 4:
	    case 6:
	    case 15:
	    case 16:
		fprintf(stderr, "     ================================================================\n");
		fprintf(stderr, "     WARNING!  Most color-mapped (palette) and true-color images will\n");
		fprintf(stderr, "     lose information irreversibly!\n");
		fprintf(stderr, "     ================================================================\n");
		fprintf(stderr, "\n");
		break;
	    case 24:
	    case 32:
		fprintf(stderr, "     Normal images (color-mapped, 8-bit grayscale, 24-bit true-color)\n");
		fprintf(stderr, "     will not lose any color info, but non-true-color images may be\n");
		fprintf(stderr, "     promoted to 24-bit mode.\n\n");
		break;
	    default:
		break;
	}
    }

    /*
    **  Now build and construct the widgets
     */
    Global.timeToDie = False;
    app = XtWidgetToApplicationContext(toplevel);
    dpy = Global.display = XtDisplay(toplevel);

    /*
    **  Call the initializers
     */

    OperationInit(toplevel);

    /*
    **  A few rogue initializers
     */
    BrushInit(toplevel);
    HelpInit(toplevel);

    SRANDOM(time(0));

    SetIconImage(toplevel);

    /*
    **  GRR 960526:  put version number in title string (and icon name?)
     */
    sprintf(xpTitle," %s", XPAINT_VERSION);
printf("\n %s\n", XPAINT_VERSION);
    XtVaSetValues(toplevel, XtNtitle, xpTitle, NULL);
 /* XtVaSetValues(toplevel, XtNiconName, xpTitle, XtNtitle, xpTitle, NULL); */

    /*
    **  Realize it  (doesn't hurt)
     */
    XtRealizeWidget(toplevel);


    /*
    **  Now open any file on the command line
     */
    if (argc != 1) {
	LocalInfo *l = XtNew(LocalInfo);
	l->pos = 0;
	l->toplevel = toplevel;
	l->nfiles = argc - 1;
	l->files = (char **) XtCalloc(argc, sizeof(char *));
	for (i = 1; i < argc; i++)
	    l->files[i - 1] = argv[i];
	l->id = XtAppAddWorkProc(app, (XtWorkProc) workProc, (XtPointer) l);
    } else if (appInfo.popped) {
	/*
	**  If nothing is coming up, bring up a blank canvas
	 */
	GraphicCreate(toplevel, 0);
    }
    /*
    **  MainLoop
     */
    do {
	XtAppNextEvent(app, &event);
	if (event.type == ButtonPress || event.type == ButtonRelease)
	    Global.currentTime = event.xbutton.time;
	XtDispatchEvent(&event);
    }
    while (!Global.timeToDie);
}
