/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class Delete
extends MatchingTask {
    private File delDir = null;
    private int verbosity = 3;
    private File f = null;

    public void execute() throws BuildException {
        if (this.f == null && this.delDir == null) {
            throw new BuildException("<file> or <dir> attribute must be set!");
        }
        if (this.f != null && this.f.exists()) {
            if (this.f.isDirectory()) {
                this.log("Directory: " + this.f.getAbsolutePath() + " cannot be removed with delete.  Use Deltree instead.");
            } else {
                this.log("Deleting: " + this.f.getAbsolutePath());
                if (!this.f.delete()) {
                    throw new BuildException("Unable to delete file " + this.f.getAbsolutePath());
                }
            }
        }
        if (this.delDir == null) {
            return;
        }
        if (!this.delDir.exists()) {
            throw new BuildException("dir does not exist!");
        }
        DirectoryScanner ds = super.getDirectoryScanner(this.delDir);
        String[] files = ds.getIncludedFiles();
        if (files.length > 0) {
            this.log("Deleting " + files.length + " files from " + this.delDir.getAbsolutePath());
            int i = 0;
            while (i < files.length) {
                File f = new File(this.delDir, files[i]);
                if (f.exists()) {
                    this.log("Deleting: " + f.getAbsolutePath(), this.verbosity);
                    if (!f.delete()) {
                        throw new BuildException("Unable to delete " + f.getAbsolutePath());
                    }
                }
                ++i;
            }
        }
    }

    public void setDir(String dir) {
        this.delDir = this.project.resolveFile(dir);
    }

    public void setFile(String file) {
        this.f = this.project.resolveFile(file);
    }

    public void setVerbose(String verbose) {
        this.verbosity = "true".equalsIgnoreCase(verbose.trim()) || "on".equalsIgnoreCase(verbose.trim()) ? 2 : 3;
    }
}

